/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.utils;

import com.djrapitops.plan.query.QueryService;
import com.pokeskies.skieskits.utils.Utils;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0018\u0010\n\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/pokeskies/skieskits/utils/PlanExtensionHelper;", "", "<init>", "()V", "Ljava/util/UUID;", "uuid", "", "getPlaytime", "(Ljava/util/UUID;)J", "Lcom/djrapitops/plan/query/QueryService;", "queryService", "Lcom/djrapitops/plan/query/QueryService;", "SkiesKits"})
public final class PlanExtensionHelper {
    @NotNull
    public static final PlanExtensionHelper INSTANCE = new PlanExtensionHelper();
    @Nullable
    private static QueryService queryService;

    private PlanExtensionHelper() {
    }

    public final long getPlaytime(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (queryService == null) {
            Utils.INSTANCE.printError("Plan integrations were not enabled correctly! Please check the logs for startup errors...");
            return 0L;
        }
        long playtime = 0L;
        QueryService queryService = PlanExtensionHelper.queryService;
        Intrinsics.checkNotNull((Object)queryService);
        for (UUID serverUUID : queryService.getCommonQueries().fetchServerUUIDs()) {
            QueryService queryService2 = PlanExtensionHelper.queryService;
            Intrinsics.checkNotNull((Object)queryService2);
            playtime += queryService2.getCommonQueries().fetchPlaytime(uuid, serverUUID, 0L, Long.MAX_VALUE);
        }
        return playtime / (long)1000;
    }

    static {
        try {
            queryService = QueryService.getInstance();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Utils.INSTANCE.printError("The Plan mod was not found or enabled! Integrations may not work right... " + Unit.INSTANCE);
        }
    }
}

