/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block;

import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import de.markusbordihn.glowsticks.item.GlowStickItem;
import de.markusbordihn.glowsticks.utils.GlowStickPlacementHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowStickBlock
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)1, (int)3);
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final Supplier<Item> glowStickItemSupplier;

    public GlowStickBlock(BlockBehaviour.Properties properties, Supplier<Item> glowStickItemSupplier) {
        super(properties);
        this.glowStickItemSupplier = glowStickItemSupplier;
        this.m_49959_(this.createInitialBlockState());
    }

    public static int getLightLevel(BlockState blockState) {
        int ageValue = (Integer)blockState.m_61143_((Property)AGE);
        return (int)Math.round(15.0 - (ageValue < 10 ? (double)ageValue * 0.25 : (double)ageValue * 0.75));
    }

    public boolean isDespawnEnabled() {
        try {
            Item item = this.glowStickItemSupplier.get();
            if (item instanceof GlowStickItem) {
                GlowStickItem glowStickItem = (GlowStickItem)item;
                return glowStickItem.isDespawnEnabled();
            }
        }
        catch (Exception e) {
            return GlowSticksConfig.glowStickDespawnEnabled;
        }
        return GlowSticksConfig.glowStickDespawnEnabled;
    }

    public int getDespawnTickRate() {
        try {
            Item item = this.glowStickItemSupplier.get();
            if (item instanceof GlowStickItem) {
                GlowStickItem glowStickItem = (GlowStickItem)item;
                return glowStickItem.getDespawnTickRate();
            }
        }
        catch (Exception e) {
            return GlowSticksConfig.glowStickDespawnTicks;
        }
        return GlowSticksConfig.glowStickDespawnTicks;
    }

    public Item getItem() {
        return this.glowStickItemSupplier.get();
    }

    public void m_48792_(Level level, BlockPos blockPos, BlockState fallingBlockState, BlockState surfaceBlockState, FallingBlockEntity fallingBlockEntity) {
        if (GlowStickPlacementHelper.isLavaBlock(surfaceBlockState)) {
            this.handleLavaDestruction(level, blockPos, fallingBlockEntity);
        } else {
            this.handleNormalLanding(level, blockPos, fallingBlockState, surfaceBlockState, fallingBlockEntity);
        }
    }

    public void m_142525_(Level level, BlockPos blockPos, FallingBlockEntity fallingBlockEntity) {
        ItemEntity droppedItem = new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)this.getItem()));
        level.m_7967_((Entity)droppedItem);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, FACING, VARIANT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction playerFacingDirection = blockPlaceContext.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacingDirection);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!this.isDespawnEnabled()) {
            return;
        }
        if (random.m_188503_(this.getDespawnTickRate()) == 0) {
            this.advanceGlowStickAge(blockState, serverLevel, blockPos);
        }
    }

    private BlockState createInitialBlockState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(1));
    }

    private void handleLavaDestruction(Level level, BlockPos lavaPos, FallingBlockEntity fallingBlockEntity) {
        GlowStickPlacementHelper.handleLavaDestruction(level, lavaPos);
        fallingBlockEntity.m_146870_();
    }

    private void handleNormalLanding(Level level, BlockPos blockPos, BlockState glowStickState, BlockState surfaceState, FallingBlockEntity fallingBlockEntity) {
        GlowStickPlacementHelper.playPlacementSound(level, blockPos, surfaceState, level.f_46441_);
        level.m_7731_(blockPos, glowStickState, 3);
        fallingBlockEntity.m_146870_();
    }

    private void advanceGlowStickAge(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos) {
        int currentAge = (Integer)blockState.m_61143_((Property)AGE);
        int newAge = currentAge + 1;
        if (newAge >= 15) {
            serverLevel.m_46961_(blockPos, true);
        } else {
            BlockState updatedState = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge));
            serverLevel.m_46597_(blockPos, updatedState);
        }
    }
}

