/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.GlowStickBlockProperties;
import de.markusbordihn.glowsticks.block.GlowStickLightBlock;
import de.markusbordihn.glowsticks.block.GlowStickLightWaterBlock;
import de.markusbordihn.glowsticks.item.ModItems;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glow_sticks");
    public static final RegistryObject<Block> GLOW_STICK_LIGHT = BLOCKS.register("glow_stick_light", () -> new GlowStickLightBlock(GlowStickBlockProperties.createLightBlockProperties()));
    public static final RegistryObject<Block> GLOW_STICK_LIGHT_WATER = BLOCKS.register("glow_stick_light_water", () -> new GlowStickLightWaterBlock(GlowStickBlockProperties.createLightBlockProperties()));
    protected static final Map<DyeColor, RegistryObject<Block>> GLOW_STICK_BLOCKS = new EnumMap<DyeColor, RegistryObject<Block>>(DyeColor.class);

    public static RegistryObject<Block> getGlowStickBlock(DyeColor dyeColor) {
        return GLOW_STICK_BLOCKS.get(dyeColor);
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.m_41065_();
            GLOW_STICK_BLOCKS.put(dyeColor, (RegistryObject<Block>)BLOCKS.register("glow_stick_" + colorName, () -> new GlowStickBlock(GlowStickBlockProperties.createGlowStickBlockProperties(), (Supplier<Item>)ModItems.getGlowStickItem(dyeColor))));
        }
    }
}

