/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.client.renderer;

import de.markusbordihn.glowsticks.block.ModBlocks;
import de.markusbordihn.glowsticks.entity.ModEntity;
import de.markusbordihn.glowsticks.entity.projectile.GlowStickProjectile;
import de.markusbordihn.glowsticks.item.GlowStickItem;
import de.markusbordihn.glowsticks.item.ModItems;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRenderer {
    public static final Logger log = LogManager.getLogger((String)"Glow Sticks");

    protected ClientRenderer() {
    }

    public static void registerItemRenderer(FMLClientSetupEvent event) {
        log.info("{} Client Setup ...", (Object)"Register Glow Sticks");
        event.enqueueWork(() -> {
            ResourceLocation animationStep = new ResourceLocation("glow_sticks", "step");
            for (DyeColor dyeColor : DyeColor.values()) {
                RegistryObject<Item> glowStickItem = ModItems.getGlowStickItem(dyeColor);
                if (glowStickItem == null) continue;
                ItemProperties.register((Item)((Item)glowStickItem.get()), (ResourceLocation)animationStep, ClientRenderer::getStepFromTag);
            }
            for (DyeColor dyeColor : DyeColor.values()) {
                RegistryObject<Block> glowStickBlock = ModBlocks.getGlowStickBlock(dyeColor);
                if (glowStickBlock == null) continue;
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)glowStickBlock.get()), (RenderType)RenderType.m_110466_());
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GLOW_STICK_LIGHT.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GLOW_STICK_LIGHT_WATER.get()), (RenderType)RenderType.m_110457_());
        });
    }

    public static float getStepFromTag(ItemStack itemStack, ClientLevel level, LivingEntity living, int id) {
        CompoundTag compoundTag;
        if (itemStack.m_41720_() instanceof GlowStickItem && living != null && (compoundTag = itemStack.m_41783_()) != null) {
            return compoundTag.m_128451_("step");
        }
        return 0.0f;
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        log.info("{} Client Renderer ...", (Object)"Register Glow Sticks");
        for (DyeColor dyeColor : DyeColor.values()) {
            RegistryObject<EntityType<GlowStickProjectile>> glowStickEntity = ModEntity.getGlowStickEntity(dyeColor);
            if (glowStickEntity == null) continue;
            event.registerEntityRenderer((EntityType)glowStickEntity.get(), ThrownItemRenderer::new);
        }
    }
}

