/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.config;

import de.markusbordihn.glowsticks.Constants;
import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    protected static final Logger log = LogManager.getLogger((String)"Glow Sticks");
    private static final String LOG_PREFIX = "[Config]";
    private static boolean isLoaded = false;
    private static Path configPath = Paths.get("", new String[0]).toAbsolutePath().resolve("config").resolve("glow_sticks");

    public static void register() {
        if (Constants.CONFIG_DIR != null) {
            configPath = Constants.CONFIG_DIR.resolve("glow_sticks");
            log.info("{} Updated configuration path to {}", (Object)LOG_PREFIX, (Object)configPath);
        }
        if (!configPath.toFile().exists()) {
            log.info("{} Creating configuration folder {}", (Object)LOG_PREFIX, (Object)Config.getConfigDirectory());
        }
        if (isLoaded) {
            log.error("{} Configuration is already loaded", (Object)LOG_PREFIX);
            log.warn("Check if configuration is loaded multiple times!");
            return;
        }
        isLoaded = true;
        GlowSticksConfig.registerConfig();
    }

    public static void registerConfigFile(String configFileName, String configFileHeader) {
        File configFile = Config.getConfigFile(configFileName.trim());
        if (configFile == null || !configFile.exists()) {
            Config.createConfigFile(Config.getConfigFile(configFileName.trim()), configFileHeader.trim());
        }
    }

    public static Properties readConfigFile(File configFile) {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(configFile.toPath());){
            properties.load(reader);
        }
        catch (Exception e) {
            log.error("{} Failed to read configuration file {}: {}", (Object)LOG_PREFIX, (Object)configFile, (Object)e);
        }
        return properties;
    }

    public static void createConfigFile(File configFile, String header) {
        Properties properties = new Properties();
        log.info("{} Creating configuration file {}", (Object)LOG_PREFIX, (Object)configFile);
        try (FileWriter writer = new FileWriter(configFile);){
            properties.store(writer, header.trim());
        }
        catch (Exception e) {
            log.error("{} Failed to create configuration file {} for {}", (Object)LOG_PREFIX, (Object)configFile, (Object)properties);
        }
    }

    public static File getConfigFile(String configFileName) {
        Path path = Config.getConfigDirectory();
        if (path != null) {
            return path.resolve(configFileName).toFile();
        }
        return null;
    }

    private static Path getConfigDirectory() {
        Path resultPath = null;
        try {
            resultPath = Files.createDirectories(configPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            log.error("{} Failed to create configuration folder {}: {}", (Object)LOG_PREFIX, (Object)configPath, (Object)e);
        }
        return resultPath;
    }

    public static void updateConfigFileIfChanged(File configFile, String configFileHeader, Properties properties, Properties unmodifiedProperties) {
        if (!properties.equals(unmodifiedProperties)) {
            log.info("{} Updating configuration file {} {}: {}", (Object)LOG_PREFIX, (Object)configFile, (Object)configFileHeader, (Object)properties);
            try (FileWriter writer = new FileWriter(configFile);){
                properties.store(writer, configFileHeader.trim());
            }
            catch (Exception e) {
                log.error("{} Failed to update configuration file {} with {}", (Object)LOG_PREFIX, (Object)configFile, (Object)properties);
            }
        } else {
            log.info("{} {} is up to date: {}", (Object)LOG_PREFIX, (Object)configFileHeader, (Object)properties);
        }
    }

    protected static int parseConfigValue(Properties properties, String key, int defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return Integer.parseInt(properties.getProperty(key).trim());
            }
            catch (Exception e) {
                log.error("{} Failed to parse Integer value for key {}: {}", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, Integer.toString(defaultValue));
        return defaultValue;
    }

    protected static boolean parseConfigValue(Properties properties, String key, boolean defaultValue) {
        if (properties.containsKey(key)) {
            try {
                return Boolean.parseBoolean(properties.getProperty(key).trim());
            }
            catch (Exception e) {
                log.error("{} Failed to parse Boolean value for key {}: {}", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, Boolean.toString(defaultValue));
        return defaultValue;
    }

    protected static Set<String> parseConfigValue(Properties properties, String key, Set<String> defaultValue) {
        if (properties.containsKey(key)) {
            try {
                String value = properties.getProperty(key).trim();
                return value.isEmpty() ? Set.of() : Set.of(value.split(","));
            }
            catch (Exception e) {
                log.error("{} Failed to parse Set[String] for key {}: {}", (Object)LOG_PREFIX, (Object)key, (Object)e);
            }
        }
        properties.setProperty(key, String.join((CharSequence)",", defaultValue));
        return defaultValue;
    }
}

