/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.config;

import de.markusbordihn.glowsticks.config.Config;
import java.io.File;
import java.util.Properties;

public class GlowSticksConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "glow_sticks.cfg";
    public static final String CONFIG_FILE_HEADER = "  Glow Sticks Configuration\n\n  This file contains the configuration for the Glow Sticks mod.\n  You can enable or disable features and adjust settings as needed.\n\n  Glow Stick Despawn:\n  - glowStickDespawnEnabled: Enable or disable the automatic despawn of glow sticks.\n  - glowStickDespawnTicks: Controls the aging probability of glow sticks during random ticks.\n    A value of 1 means every random tick has a 100% chance to age the glow stick.\n    A value of 2 means every random tick has a 50% chance to age the glow stick.\n    A value of 5 means every random tick has a 20% chance to age the glow stick.\n    Higher values make glow sticks last longer on average.\n    When a glow stick reaches age 15, it will despawn automatically.\n\n";
    public static boolean glowStickDespawnEnabled = true;
    public static int glowStickDespawnTicks = 2;

    public static void registerConfig() {
        GlowSticksConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        GlowSticksConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = GlowSticksConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = GlowSticksConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        glowStickDespawnEnabled = GlowSticksConfig.parseConfigValue(properties, "glowStickDespawnEnabled", glowStickDespawnEnabled);
        glowStickDespawnTicks = GlowSticksConfig.parseConfigValue(properties, "glowStickDespawnTicks", glowStickDespawnTicks);
        GlowSticksConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

