/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.entity;

import de.markusbordihn.glowsticks.block.ModBlocks;
import de.markusbordihn.glowsticks.entity.projectile.GlowStickProjectile;
import de.markusbordihn.glowsticks.item.ModItems;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEntity {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"glow_sticks");
    protected static final Map<DyeColor, RegistryObject<EntityType<GlowStickProjectile>>> GLOW_STICK_ENTITIES = new EnumMap<DyeColor, RegistryObject<EntityType<GlowStickProjectile>>>(DyeColor.class);
    public static final RegistryObject<EntityType<GlowStickProjectile>> GLOW_STICK = GLOW_STICK_ENTITIES.get(DyeColor.WHITE);

    protected ModEntity() {
    }

    public static RegistryObject<EntityType<GlowStickProjectile>> getGlowStickEntity(DyeColor dyeColor) {
        return GLOW_STICK_ENTITIES.get(dyeColor);
    }

    private static GlowStickProjectile createGlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, DyeColor dyeColor) {
        return new GlowStickProjectile(entityType, level, dyeColor, () -> (Block)ModBlocks.getGlowStickBlock(dyeColor).get(), () -> (Item)ModItems.getGlowStickItem(dyeColor).get(), (Supplier<Block>)ModBlocks.GLOW_STICK_LIGHT, (Supplier<Block>)ModBlocks.GLOW_STICK_LIGHT_WATER);
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.m_41065_();
            GLOW_STICK_ENTITIES.put(dyeColor, (RegistryObject<EntityType<GlowStickProjectile>>)ENTITIES.register("glow_stick_" + colorName, () -> EntityType.Builder.m_20704_((entityType, level) -> ModEntity.createGlowStickProjectile((EntityType<? extends GlowStickProjectile>)entityType, level, dyeColor), (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_(new ResourceLocation("glow_sticks", "glow_stick_" + colorName).toString())));
        }
    }
}

