/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.entity.projectile;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.GlowStickLightBlock;
import de.markusbordihn.glowsticks.utils.GlowStickPlacementHelper;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GlowStickProjectile
extends ThrowableItemProjectile {
    private static final int TICK_TTL = 650;
    protected final Supplier<Block> lightWaterBlock;
    protected final DyeColor dyeColor;
    protected final Supplier<Item> defaultItem;
    protected final Supplier<Block> lightBlock;
    protected Supplier<Block> defaultBlock = null;
    protected Direction defaultDirection = Direction.NORTH;
    private int ticks;

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, level);
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
    }

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, LivingEntity thrower, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, thrower, level);
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultDirection = thrower.m_6350_().m_122424_();
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
    }

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, double x, double y, double z, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, x, y, z, level);
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    protected Item m_7881_() {
        return this.defaultItem != null ? this.defaultItem.get() : null;
    }

    private boolean canPlaceBlock(BlockState blockState) {
        if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_)) {
            return true;
        }
        if (blockState.m_247087_()) {
            return true;
        }
        if (blockState.m_60713_(Blocks.f_50125_) || blockState.m_60713_(Blocks.f_152499_)) {
            return true;
        }
        if (blockState.m_60800_((BlockGetter)this.m_9236_(), BlockPos.f_121853_) == 0.0f) {
            return true;
        }
        return !blockState.m_60819_().m_76178_();
    }

    private void dropDefaultItem(Level level, BlockPos blockPos) {
        level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)this.m_7881_())));
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().f_46443_) {
            Vec3 location = entityHitResult.m_82450_();
            this.dropDefaultItem(this.m_9236_(), new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_));
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().f_46443_ && this.defaultBlock != null) {
            BlockPos blockPos = blockHitResult.m_82425_();
            BlockPos placePos = blockPos.m_121945_(blockHitResult.m_82434_());
            BlockState newGlowStickState = this.defaultBlock.get().m_49966_();
            BlockState targetState = this.m_9236_().m_8055_(placePos);
            if (this.canPlaceBlock(targetState)) {
                this.handleGlowStickPlacement(placePos, newGlowStickState, targetState);
            } else {
                this.dropDefaultItem(this.m_9236_(), placePos);
            }
        }
        this.m_146870_();
    }

    private void handleGlowStickPlacement(BlockPos placePos, BlockState glowStickState, BlockState targetState) {
        if (GlowStickPlacementHelper.isLavaBlock(targetState)) {
            this.handleLavaDestruction(placePos);
        } else {
            this.handleNormalPlacement(placePos, glowStickState, targetState);
        }
    }

    private void handleLavaDestruction(BlockPos lavaPos) {
        GlowStickPlacementHelper.handleLavaDestruction(this.m_9236_(), lavaPos);
    }

    private void handleNormalPlacement(BlockPos placePos, BlockState glowStickState, BlockState targetState) {
        GlowStickPlacementHelper.playPlacementSound(this.m_9236_(), placePos, targetState, this.f_19796_);
        this.placeGlowStickNormally(placePos, glowStickState, targetState);
    }

    private void placeGlowStickNormally(BlockPos placePos, BlockState glowStickState, BlockState targetState) {
        boolean isWater = targetState.m_60713_(Blocks.f_49990_) && targetState.m_60819_().m_76186_() >= 8;
        BlockState finalState = (BlockState)((BlockState)((BlockState)glowStickState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)this.defaultDirection)).m_61124_((Property)GlowStickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).m_61124_((Property)GlowStickBlock.VARIANT, (Comparable)Integer.valueOf(this.f_19796_.m_216339_(1, 4)));
        this.m_9236_().m_46597_(placePos, finalState);
    }

    public void m_8119_() {
        if (!this.m_6084_()) {
            return;
        }
        super.m_8119_();
        if (++this.ticks > 650) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_9236_().f_46443_ && !this.m_20069_() && this.ticks % 12 == 0) {
            Vec3 deltaMovement = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + deltaMovement.f_82479_ * 0.75, this.m_20186_() + deltaMovement.f_82480_ * 0.75, this.m_20189_() + deltaMovement.f_82481_ * 0.75, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
        }
        if (!this.m_9236_().f_46443_) {
            BlockPos lightBlockPosition = this.m_20183_().m_7494_();
            BlockState currentBlockState = this.m_9236_().m_8055_(lightBlockPosition);
            if (currentBlockState.m_60795_() || currentBlockState.m_60713_(Blocks.f_49990_)) {
                BlockState newLightBlockState = currentBlockState.m_60713_(Blocks.f_49990_) ? this.lightWaterBlock.get().m_49966_() : this.lightBlock.get().m_49966_();
                this.m_9236_().m_46597_(lightBlockPosition, newLightBlockState);
                Block placedBlock = this.m_9236_().m_8055_(lightBlockPosition).m_60734_();
                if (placedBlock instanceof GlowStickLightBlock) {
                    GlowStickLightBlock glowStickLightBlock = (GlowStickLightBlock)placedBlock;
                    glowStickLightBlock.scheduleTick(this.m_9236_(), lightBlockPosition);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlowStickProjectile)) {
            return false;
        }
        GlowStickProjectile other = (GlowStickProjectile)((Object)obj);
        if (!super.equals(obj)) {
            return false;
        }
        return this.ticks == other.ticks && this.dyeColor == other.dyeColor && this.defaultDirection == other.defaultDirection && Objects.equals(this.defaultBlock, other.defaultBlock) && Objects.equals(this.defaultItem, other.defaultItem) && Objects.equals(this.lightBlock, other.lightBlock) && Objects.equals(this.lightWaterBlock, other.lightWaterBlock);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ticks;
        result = 31 * result + (this.dyeColor != null ? this.dyeColor.hashCode() : 0);
        result = 31 * result + (this.defaultDirection != null ? this.defaultDirection.hashCode() : 0);
        result = 31 * result + (this.defaultBlock != null ? this.defaultBlock.hashCode() : 0);
        result = 31 * result + (this.defaultItem != null ? this.defaultItem.hashCode() : 0);
        result = 31 * result + (this.lightBlock != null ? this.lightBlock.hashCode() : 0);
        result = 31 * result + (this.lightWaterBlock != null ? this.lightWaterBlock.hashCode() : 0);
        return result;
    }
}

