/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.item;

import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import de.markusbordihn.glowsticks.entity.projectile.GlowStickProjectile;
import de.markusbordihn.glowsticks.utils.ToolTips;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GlowStickItem
extends Item {
    public static final String NAME = "glow_stick";
    public static final String TAG_ACTIVATED = "activated";
    public static final String TAG_STEP = "step";
    public static final int ANIMATION_STEPS = 6;
    public static final int DURATION_TICKS = 12;
    protected final Supplier<Block> blockSupplier;
    protected final boolean despawnEnabled;
    protected final int despawnTickRate;
    private final DyeColor dyeColor;

    public GlowStickItem(Item.Properties properties, Supplier<Block> blockSupplier, DyeColor dyeColor) {
        this(properties, blockSupplier, dyeColor, GlowSticksConfig.glowStickDespawnEnabled, GlowSticksConfig.glowStickDespawnTicks);
    }

    public GlowStickItem(Item.Properties properties, Supplier<Block> blockSupplier, DyeColor dyeColor, boolean despawnEnabled, int despawnTickRate) {
        super(properties);
        this.blockSupplier = blockSupplier;
        this.despawnEnabled = despawnEnabled;
        this.despawnTickRate = despawnTickRate;
        this.dyeColor = dyeColor;
    }

    public static boolean isActivated(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TAG_ACTIVATED);
    }

    public static void setActivated(ItemStack stack, boolean activated) {
        stack.m_41784_().m_128379_(TAG_ACTIVATED, activated);
    }

    public static int getStep(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128451_(TAG_STEP) : 0;
    }

    public static int setStep(ItemStack itemStack, int step) {
        itemStack.m_41784_().m_128405_(TAG_STEP, step);
        return step;
    }

    public static int increaseStep(ItemStack itemStack) {
        return GlowStickItem.setStep(itemStack, GlowStickItem.getStep(itemStack) + 1);
    }

    public GlowStickProjectile getGlowStickEntity(Level level, LivingEntity entity) {
        throw new UnsupportedOperationException("GlowStickItem.getGlowStickEntity() not implemented!");
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public boolean isDespawnEnabled() {
        return this.despawnEnabled;
    }

    public int getDespawnTickRate() {
        return this.despawnTickRate;
    }

    public int m_8105_(ItemStack itemStack) {
        return 12;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (GlowStickItem.isActivated(itemStack)) {
            if (!level.f_46443_) {
                GlowStickProjectile entity = this.getGlowStickEntity(level, (LivingEntity)player);
                entity.m_37446_(itemStack);
                entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                level.m_7967_((Entity)entity);
                player.m_36335_().m_41524_((Item)this, 12);
                itemStack.m_41774_(1);
            }
            GlowStickItem.setActivated(itemStack, false);
            GlowStickItem.setStep(itemStack, 0);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
        if (!level.f_46443_ && this.despawnEnabled && count % this.despawnTickRate == 0) {
            int step = GlowStickItem.increaseStep(itemStack);
            if (step == 4) {
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12514_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (step > 6) {
                GlowStickItem.setStep(itemStack, 0);
            }
        }
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int timeLeft) {
        if (!GlowStickItem.isActivated(itemStack)) {
            GlowStickItem.setStep(itemStack, 0);
        }
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && !GlowStickItem.isActivated(itemStack)) {
            GlowStickItem.setActivated(itemStack, true);
        }
        return itemStack;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipList, (Component)Component.m_237115_((String)("text.glow_sticks.glow_stick_" + String.valueOf(this.dyeColor) + "_description")).m_130940_(ChatFormatting.GRAY));
        ToolTips.addTooltip(tooltipList, (Component)Component.m_237110_((String)"text.glow_sticks.glow_stick_use", (Object[])new Object[]{this.despawnTickRate}).m_130940_(ChatFormatting.GREEN));
    }
}

