/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class GlowStickPlacementHelper {
    private static final float PLACEMENT_SOUND_VOLUME = 0.3f;
    private static final float PITCH_VARIATION_FACTOR = 0.2f;
    private static final float LAVA_EXPLOSION_STRENGTH = 0.5f;

    private GlowStickPlacementHelper() {
    }

    public static boolean isLavaBlock(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_49991_) || blockState.m_60819_().m_192917_((Fluid)Fluids.f_76195_);
    }

    public static void createLavaExplosionEffect(Level level, BlockPos position) {
        level.m_255391_(null, (double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, 0.5f, false, Level.ExplosionInteraction.NONE);
    }

    public static void playLavaInteractionSounds(Level level, BlockPos position) {
        level.m_5594_(null, position, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f);
        level.m_5594_(null, position, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.18f, 0.8f);
    }

    public static void handleLavaDestruction(Level level, BlockPos lavaPosition) {
        GlowStickPlacementHelper.createLavaExplosionEffect(level, lavaPosition);
        GlowStickPlacementHelper.playLavaInteractionSounds(level, lavaPosition);
    }

    private static float calculatePitchWithVariation(RandomSource random) {
        return 1.0f + (random.m_188501_() - 0.5f) * 0.2f;
    }

    private static void playSound(Level level, BlockPos position, SoundEvent soundEvent, float pitch, float volume) {
        level.m_5594_(null, position, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    private static boolean isStoneLikeSurface(Block surfaceBlock, BlockState surfaceState) {
        return surfaceBlock == Blocks.f_50069_ || surfaceBlock == Blocks.f_50652_ || surfaceBlock == Blocks.f_152550_ || surfaceState.m_204336_(BlockTags.f_13091_);
    }

    private static boolean isDirtLikeSurface(Block surfaceBlock, BlockState surfaceState) {
        return surfaceBlock == Blocks.f_50440_ || surfaceBlock == Blocks.f_50493_ || surfaceState.m_204336_(BlockTags.f_144274_);
    }

    private static boolean isWoodLikeSurface(BlockState surfaceState) {
        return surfaceState.m_204336_(BlockTags.f_13106_) || surfaceState.m_204336_(BlockTags.f_13090_);
    }

    private static boolean isSandLikeSurface(Block surfaceBlock) {
        return surfaceBlock == Blocks.f_49992_ || surfaceBlock == Blocks.f_49993_ || surfaceBlock == Blocks.f_49994_;
    }

    private static boolean isLeafSurface(BlockState surfaceState) {
        return surfaceState.m_204336_(BlockTags.f_13035_);
    }

    private static boolean isWaterSurface(Block surfaceBlock, BlockState surfaceState) {
        return surfaceBlock == Blocks.f_49990_ || surfaceState.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
    }

    public static void playPlacementSound(Level level, BlockPos position, BlockState surfaceState, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        Block surfaceBlock = surfaceState.m_60734_();
        float basePitch = GlowStickPlacementHelper.calculatePitchWithVariation(random);
        if (GlowStickPlacementHelper.isStoneLikeSurface(surfaceBlock, surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12065_, basePitch, 0.3f);
        } else if (GlowStickPlacementHelper.isDirtLikeSurface(surfaceBlock, surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_144190_, basePitch * 0.8f, 0.3f);
        } else if (GlowStickPlacementHelper.isWoodLikeSurface(surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12635_, basePitch, 0.3f);
        } else if (GlowStickPlacementHelper.isSandLikeSurface(surfaceBlock)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12334_, basePitch * 0.7f, 0.3f);
        } else if (GlowStickPlacementHelper.isLeafSurface(surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_11991_, basePitch * 1.2f, 0.15f);
        } else if (GlowStickPlacementHelper.isWaterSurface(surfaceBlock, surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12278_, basePitch * 1.5f, 0.120000005f);
        } else if (GlowStickPlacementHelper.isLavaBlock(surfaceState)) {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12032_, basePitch * 0.8f, 0.18f);
        } else {
            GlowStickPlacementHelper.playSound(level, position, SoundEvents.f_12338_, basePitch, 0.3f);
        }
    }
}

