/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.glowsticks.block.glowstick.BlockStateManager;
import de.markusbordihn.glowsticks.block.glowstick.LavaInteraction;
import de.markusbordihn.glowsticks.block.glowstick.ParticleEffects;
import de.markusbordihn.glowsticks.block.glowstick.RedstoneCapable;
import de.markusbordihn.glowsticks.block.glowstick.WaypointNavigation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowStickBlock
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Property<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)5);
    public static final BooleanProperty CONTROLLED = BooleanProperty.create((String)"controlled");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final MapCodec<GlowStickBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GlowStickBlock.propertiesCodec(), (App)DyeColor.CODEC.fieldOf("dye_color").forGetter(block -> block.dyeColor), (App)Codec.INT.fieldOf("despawn_tick_rate").forGetter(block -> block.despawnTickRate)).apply((Applicative)instance, GlowStickBlock::new));
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final DyeColor dyeColor;
    private final int despawnTickRate;

    public GlowStickBlock(BlockBehaviour.Properties properties, DyeColor dyeColor, int despawnTickRate) {
        super(properties);
        this.dyeColor = dyeColor;
        this.despawnTickRate = despawnTickRate;
        this.registerDefaultState(BlockStateManager.createInitialBlockState(this));
    }

    public static int getLightLevel(BlockState blockState) {
        return BlockStateManager.calculateLightLevel(blockState);
    }

    public DyeColor getGlowStickColor() {
        return this.dyeColor;
    }

    public Item asItem() {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"glow_sticks", (String)("glow_stick_" + this.dyeColor.getName()));
        return (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
    }

    public void onLand(Level level, BlockPos blockPos, BlockState fallingBlockState, BlockState surfaceBlockState, FallingBlockEntity fallingBlockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (LavaInteraction.isLavaBlock(surfaceBlockState)) {
            LavaInteraction.handleLavaDestruction(level, blockPos);
            fallingBlockEntity.discard();
        }
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, FACING, VARIANT, WATERLOGGED, CONTROLLED, POWERED});
    }

    public FluidState getFluidState(BlockState blockState) {
        return BlockStateManager.getFluidState(blockState);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockStateManager.handleRandomTick(blockState, serverLevel, blockPos, random, this.despawnTickRate);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, Orientation orientation, boolean isMoving) {
        super.neighborChanged(blockState, level, blockPos, neighborBlock, orientation, isMoving);
        RedstoneCapable.handleNeighborChange(blockState, level, blockPos);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.dyeColor.getTextureDiffuseColor();
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        super.animateTick(blockState, level, blockPos, random);
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        ParticleEffects.handleParticleAnimation(blockState, level, blockPos, random, this.dyeColor);
        WaypointNavigation.handleWaypointParticles(clientLevel, blockPos, random, this.dyeColor);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, placer, itemStack);
        RedstoneCapable.handleBlockPlacement(level, blockPos, blockState);
    }

    public int getSignal(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return 0;
    }

    public boolean isSignalSource(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)CONTROLLED);
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockPos placementPos;
        BlockPos belowPos;
        Level level = blockPlaceContext.getLevel();
        BlockState belowState = level.getBlockState(belowPos = (placementPos = blockPlaceContext.getClickedPos()).below());
        if (belowState.getBlock() instanceof GlowStickBlock) {
            return null;
        }
        BlockState existingState = level.getBlockState(placementPos);
        if (existingState.getBlock() instanceof GlowStickBlock) {
            return null;
        }
        return BlockStateManager.getStateForPlacement(this, blockPlaceContext);
    }
}

