/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlowStickLightBlock
extends Block {
    public static final Logger log = LogManager.getLogger((String)"Glow Sticks");
    protected static final VoxelShape SHAPE_AABB = Block.box((double)7.5, (double)7.5, (double)7.5, (double)8.5, (double)8.5, (double)8.5);
    private static final int TICK_TTL = 10;

    public GlowStickLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void scheduleTick(Level level, BlockPos blockPos) {
        if (!level.getBlockTicks().hasScheduledTick(blockPos, (Object)this)) {
            level.scheduleTick(blockPos, (Block)this, 10);
        }
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_AABB;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, LivingEntity placer, ItemStack itemStack) {
        this.scheduleTick(level, blockPos);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        Block block = blockState.getBlock();
        if (!level.isClientSide && block instanceof GlowStickLightBlock) {
            level.removeBlock(blockPos, true);
        }
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (blockState.getBlock() instanceof GlowStickLightBlock) {
            this.scheduleTick((Level)serverLevel, blockPos);
        }
    }
}

