/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.GlowStickBlockProperties;
import de.markusbordihn.glowsticks.block.GlowStickLightBlock;
import de.markusbordihn.glowsticks.block.GlowStickLightWaterBlock;
import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"glow_sticks");
    public static final RegistryObject<Block> GLOW_STICK_LIGHT = BLOCKS.register("glow_stick_light", () -> new GlowStickLightBlock(GlowStickBlockProperties.createLightBlockProperties("glow_stick_light")));
    public static final RegistryObject<Block> GLOW_STICK_LIGHT_WATER = BLOCKS.register("glow_stick_light_water", () -> new GlowStickLightWaterBlock(GlowStickBlockProperties.createLightBlockProperties("glow_stick_light_water")));
    protected static final Map<DyeColor, RegistryObject<Block>> GLOW_STICK_BLOCKS = new EnumMap<DyeColor, RegistryObject<Block>>(DyeColor.class);
    protected static final Map<DyeColor, RegistryObject<Block>> CREATIVE_GLOW_STICK_BLOCKS = new EnumMap<DyeColor, RegistryObject<Block>>(DyeColor.class);

    public static RegistryObject<Block> getGlowStickBlock(DyeColor dyeColor) {
        return GLOW_STICK_BLOCKS.get(dyeColor);
    }

    public static RegistryObject<Block> getCreativeGlowStickBlock(DyeColor dyeColor) {
        return CREATIVE_GLOW_STICK_BLOCKS.get(dyeColor);
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.getName();
            String blockName = "glow_stick_" + colorName;
            GLOW_STICK_BLOCKS.put(dyeColor, (RegistryObject<Block>)BLOCKS.register(blockName, () -> new GlowStickBlock(GlowStickBlockProperties.createGlowStickBlockProperties(blockName), dyeColor, GlowSticksConfig.despawnTicks)));
            String creativeBlockName = "creative_glow_stick_" + colorName;
            CREATIVE_GLOW_STICK_BLOCKS.put(dyeColor, (RegistryObject<Block>)BLOCKS.register(creativeBlockName, () -> new GlowStickBlock(GlowStickBlockProperties.createGlowStickBlockProperties(creativeBlockName), dyeColor, 0)));
        }
    }
}

