/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block.glowstick;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.glowstick.RedstoneCapable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class BlockStateManager {
    public static BlockState createInitialBlockState(GlowStickBlock block) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.getStateDefinition().any()).setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(0))).setValue(GlowStickBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)GlowStickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GlowStickBlock.VARIANT, (Comparable)Integer.valueOf(1))).setValue((Property)GlowStickBlock.CONTROLLED, (Comparable)Boolean.valueOf(false))).setValue((Property)GlowStickBlock.POWERED, (Comparable)Boolean.valueOf(false));
    }

    public static BlockState getStateForPlacement(GlowStickBlock block, BlockPlaceContext context) {
        Direction playerFacingDirection = context.getHorizontalDirection().getOpposite();
        Level level = context.getLevel();
        BlockPos blockPlacementPos = context.getClickedPos();
        if (!context.canPlace()) {
            blockPlacementPos = blockPlacementPos.relative(context.getClickedFace());
        }
        BlockState baseState = (BlockState)block.defaultBlockState().setValue(GlowStickBlock.FACING, (Comparable)playerFacingDirection);
        return RedstoneCapable.getInitialPlacementState(baseState, level, blockPlacementPos);
    }

    public static FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)GlowStickBlock.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public static void handleRandomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random, int despawnTickRate) {
        if (despawnTickRate <= 0 || random.nextInt(despawnTickRate) != 0 || ((Boolean)blockState.getValue((Property)GlowStickBlock.CONTROLLED)).booleanValue()) {
            return;
        }
        int currentAge = (Integer)blockState.getValue((Property)GlowStickBlock.AGE);
        if (currentAge >= 15) {
            serverLevel.destroyBlock(blockPos, true);
            return;
        }
        BlockState updatedState = (BlockState)blockState.setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(currentAge + 1));
        serverLevel.setBlockAndUpdate(blockPos, updatedState);
    }

    public static int calculateLightLevel(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)GlowStickBlock.CONTROLLED)).booleanValue() && !((Boolean)blockState.getValue((Property)GlowStickBlock.POWERED)).booleanValue()) {
            return 0;
        }
        int ageValue = (Integer)blockState.getValue((Property)GlowStickBlock.AGE);
        return (int)Math.round(15.0 - (ageValue < 10 ? (double)ageValue * 0.25 : (double)ageValue * 0.75));
    }
}

