/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block.glowstick;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ParticleEffects {
    public static void handleParticleAnimation(BlockState blockState, Level level, BlockPos blockPos, RandomSource random, DyeColor dyeColor) {
        ClientLevel clientLevel;
        block5: {
            block4: {
                if (!(level instanceof ClientLevel)) break block4;
                clientLevel = (ClientLevel)level;
                if (ParticleEffects.shouldSpawnParticles(blockState, random)) break block5;
            }
            return;
        }
        int currentAge = (Integer)blockState.getValue((Property)GlowStickBlock.AGE);
        float ageFactor = Math.max(0.2f, 1.0f - (float)currentAge / 15.0f);
        float size = Math.max(0.8f, ageFactor * 1.2f);
        int adjustedColor = ParticleEffects.calculateAdjustedColor(dyeColor, ageFactor);
        ParticleEffects.spawnMainParticle(clientLevel, blockPos, random, adjustedColor, size);
        if (currentAge <= 5 && random.nextInt(3) == 0) {
            ParticleEffects.spawnExtraParticle(clientLevel, blockPos, random, adjustedColor, size);
        }
    }

    private static boolean shouldSpawnParticles(BlockState blockState, RandomSource random) {
        return GlowSticksConfig.spawnRandomParticles && random.nextInt(GlowSticksConfig.randomParticleSpawnRate) == 0 && (Integer)blockState.getValue((Property)GlowStickBlock.AGE) < 15;
    }

    private static int calculateAdjustedColor(DyeColor dyeColor, float brightness) {
        int originalColor = dyeColor.getTextureDiffuseColor();
        int red = originalColor >> 16 & 0xFF;
        int green = originalColor >> 8 & 0xFF;
        int blue = originalColor & 0xFF;
        int adjustedRed = Math.min(255, (int)((float)red * brightness));
        int adjustedGreen = Math.min(255, (int)((float)green * brightness));
        int adjustedBlue = Math.min(255, (int)((float)blue * brightness));
        return adjustedRed << 16 | adjustedGreen << 8 | adjustedBlue;
    }

    private static void spawnMainParticle(ClientLevel clientLevel, BlockPos blockPos, RandomSource random, int color, float size) {
        clientLevel.addParticle((ParticleOptions)new DustParticleOptions(color, size), (double)blockPos.getX() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.3, (double)blockPos.getY() + 0.1, (double)blockPos.getZ() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.3, 0.0, 0.01, 0.0);
    }

    private static void spawnExtraParticle(ClientLevel clientLevel, BlockPos blockPos, RandomSource random, int color, float size) {
        clientLevel.addParticle((ParticleOptions)new DustParticleOptions(color, size * 0.7f), (double)blockPos.getX() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.4, (double)blockPos.getY() + 0.15, (double)blockPos.getZ() + 0.5 + ((double)random.nextFloat() - 0.5) * 0.4, 0.0, 0.005, 0.0);
    }
}

