/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block.glowstick;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PlacementSounds {
    private static final float PLACEMENT_SOUND_VOLUME = 0.3f;
    private static final float PITCH_VARIATION_FACTOR = 0.2f;

    public static void playPlacementSound(Level level, BlockPos position, BlockState surfaceState, RandomSource random) {
        Block surfaceBlock = surfaceState.getBlock();
        float pitch = 1.0f + (random.nextFloat() - 0.5f) * 0.2f;
        SoundEvent soundEvent = PlacementSounds.determinePlacementSound(surfaceBlock, surfaceState);
        level.playSound(null, position, soundEvent, SoundSource.BLOCKS, 0.3f, pitch);
    }

    private static SoundEvent determinePlacementSound(Block surfaceBlock, BlockState surfaceState) {
        if (PlacementSounds.isStoneLikeSurface(surfaceBlock, surfaceState)) {
            return SoundEvents.STONE_PLACE;
        }
        if (PlacementSounds.isDirtLikeSurface(surfaceBlock, surfaceState)) {
            return SoundEvents.GRAVEL_PLACE;
        }
        if (surfaceState.is(BlockTags.LOGS) || surfaceState.is(BlockTags.PLANKS)) {
            return SoundEvents.WOOD_PLACE;
        }
        if (PlacementSounds.isSandLikeSurface(surfaceBlock)) {
            return SoundEvents.SAND_PLACE;
        }
        if (surfaceState.is(BlockTags.LEAVES)) {
            return SoundEvents.GRASS_PLACE;
        }
        return SoundEvents.STONE_PLACE;
    }

    private static boolean isStoneLikeSurface(Block surfaceBlock, BlockState surfaceState) {
        return surfaceBlock == Blocks.STONE || surfaceBlock == Blocks.COBBLESTONE || surfaceBlock == Blocks.DEEPSLATE || surfaceState.is(BlockTags.STONE_BRICKS);
    }

    private static boolean isDirtLikeSurface(Block surfaceBlock, BlockState surfaceState) {
        return surfaceBlock == Blocks.GRASS_BLOCK || surfaceBlock == Blocks.DIRT || surfaceState.is(BlockTags.DIRT);
    }

    private static boolean isSandLikeSurface(Block surfaceBlock) {
        return surfaceBlock == Blocks.SAND || surfaceBlock == Blocks.RED_SAND || surfaceBlock == Blocks.GRAVEL;
    }
}

