/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.block.glowstick;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneCapable {
    public static boolean hasRedstoneCapableNeighbor(Level level, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = blockPos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (!neighborState.isSignalSource() && level.getSignal(neighborPos, direction) <= 0 && level.getDirectSignal(neighborPos, direction) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getStrongestNeighborSignal(Level level, BlockPos blockPos) {
        int maxSignal = 0;
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = blockPos.relative(direction);
            int directSignal = level.getSignal(neighborPos, direction);
            if ((maxSignal = Math.max(maxSignal, directSignal)) >= 15) {
                return 15;
            }
            int indirectSignal = level.getDirectSignal(neighborPos, direction);
            if ((maxSignal = Math.max(maxSignal, indirectSignal)) < 15) continue;
            return 15;
        }
        return maxSignal;
    }

    public static void handleNeighborChange(BlockState blockState, Level level, BlockPos blockPos) {
        boolean currentlyControlled;
        boolean shouldBeControlled = RedstoneCapable.hasRedstoneCapableNeighbor(level, blockPos);
        if (shouldBeControlled != (currentlyControlled = ((Boolean)blockState.getValue((Property)GlowStickBlock.CONTROLLED)).booleanValue())) {
            RedstoneCapable.updateControlState(blockState, level, blockPos, shouldBeControlled);
            return;
        }
        if (!currentlyControlled) {
            return;
        }
        RedstoneCapable.updateRedstoneState(blockState, level, blockPos);
    }

    public static void handleBlockPlacement(Level level, BlockPos blockPos, BlockState blockState) {
        if (level.isClientSide) {
            return;
        }
        boolean hasRedstoneNeighbor = RedstoneCapable.hasRedstoneCapableNeighbor(level, blockPos);
        if (hasRedstoneNeighbor != (Boolean)blockState.getValue((Property)GlowStickBlock.CONTROLLED)) {
            RedstoneCapable.updateControlState(blockState, level, blockPos, hasRedstoneNeighbor);
            RedstoneCapable.updateNeighborConnections(level, blockPos);
        }
    }

    private static void updateControlState(BlockState blockState, Level level, BlockPos blockPos, boolean isControlled) {
        int redstonePowerLevel;
        BlockState updatedState = (BlockState)blockState.setValue((Property)GlowStickBlock.CONTROLLED, (Comparable)Boolean.valueOf(isControlled));
        updatedState = isControlled ? (BlockState)((BlockState)updatedState.setValue((Property)GlowStickBlock.POWERED, (Comparable)Boolean.valueOf((redstonePowerLevel = RedstoneCapable.getStrongestNeighborSignal(level, blockPos)) > 0))).setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(15 - redstonePowerLevel)) : (BlockState)((BlockState)updatedState.setValue((Property)GlowStickBlock.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(0));
        level.setBlock(blockPos, updatedState, 3);
    }

    private static void updateRedstoneState(BlockState blockState, Level level, BlockPos blockPos) {
        int newRedstonePower;
        int currentRedstonePower = 15 - (Integer)blockState.getValue((Property)GlowStickBlock.AGE);
        if (currentRedstonePower != (newRedstonePower = RedstoneCapable.getStrongestNeighborSignal(level, blockPos))) {
            BlockState updatedState = (BlockState)((BlockState)blockState.setValue((Property)GlowStickBlock.POWERED, (Comparable)Boolean.valueOf(newRedstonePower > 0))).setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(15 - newRedstonePower));
            level.setBlock(blockPos, updatedState, 3);
        }
    }

    public static BlockState getInitialPlacementState(BlockState defaultState, Level level, BlockPos blockPos) {
        boolean isRedstoneControlled = RedstoneCapable.hasRedstoneCapableNeighbor(level, blockPos);
        int initialAge = 0;
        boolean isPowered = false;
        if (isRedstoneControlled) {
            int redstonePowerLevel = RedstoneCapable.getStrongestNeighborSignal(level, blockPos);
            isPowered = redstonePowerLevel > 0;
            initialAge = 15 - redstonePowerLevel;
        }
        return (BlockState)((BlockState)((BlockState)defaultState.setValue((Property)GlowStickBlock.CONTROLLED, (Comparable)Boolean.valueOf(isRedstoneControlled))).setValue((Property)GlowStickBlock.POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)GlowStickBlock.AGE, (Comparable)Integer.valueOf(initialAge));
    }

    private static void updateNeighborConnections(Level level, BlockPos blockPos) {
        level.updateNeighborsAt(blockPos, level.getBlockState(blockPos).getBlock());
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = blockPos.relative(direction);
            level.updateNeighborsAt(neighborPos, level.getBlockState(neighborPos).getBlock());
        }
    }
}

