/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.client.renderer;

import de.markusbordihn.glowsticks.block.ModBlocks;
import de.markusbordihn.glowsticks.entity.ModEntity;
import de.markusbordihn.glowsticks.entity.projectile.GlowStickProjectile;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRenderer {
    public static final Logger log = LogManager.getLogger((String)"Glow Sticks");

    protected ClientRenderer() {
    }

    @SubscribeEvent
    public static void registerItemRenderer(FMLClientSetupEvent event) {
        log.info("{} Client Setup ...", (Object)"Register Glow Sticks");
        event.enqueueWork(() -> {
            for (DyeColor dyeColor : DyeColor.values()) {
                RegistryObject<Block> creativeGlowStickBlock;
                RegistryObject<Block> glowStickBlock = ModBlocks.getGlowStickBlock(dyeColor);
                if (glowStickBlock != null) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)glowStickBlock.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
                }
                if ((creativeGlowStickBlock = ModBlocks.getCreativeGlowStickBlock(dyeColor)) == null) continue;
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)creativeGlowStickBlock.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GLOW_STICK_LIGHT.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT_MIPPED);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GLOW_STICK_LIGHT_WATER.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT_MIPPED);
        });
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        log.info("{} Client Renderer ...", (Object)"Register Glow Sticks");
        for (DyeColor dyeColor : DyeColor.values()) {
            RegistryObject<EntityType<GlowStickProjectile>> glowStickEntity = ModEntity.getGlowStickEntity(dyeColor);
            if (glowStickEntity == null) continue;
            event.registerEntityRenderer((EntityType)glowStickEntity.get(), ThrownItemRenderer::new);
        }
    }
}

