/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.config;

import de.markusbordihn.glowsticks.config.Config;
import java.io.File;
import java.util.Properties;

public class GlowSticksConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "glow_sticks.cfg";
    public static final String CONFIG_FILE_HEADER = "  Glow Sticks Configuration\n\n  This file contains the configuration for the Glow Sticks mod.\n  You can enable or disable features and adjust settings as needed.\n\n  Glow Stick Despawn:\n  - despawnTicks: Controls the aging probability of glow sticks during random ticks.\n    A value 0 means glow sticks will never age automatically.\n    A value of 1 means every random tick has a 100% chance to age the glow stick.\n    A value of 2 means every random tick has a 50% chance to age the glow stick.\n    A value of 5 means every random tick has a 20% chance to age the glow stick.\n    Higher values make glow sticks last longer on average.\n    When a glow stick reaches age 15, it will despawn automatically.\n\n  Particle Effects (Client Side Only):\n  - spawnRandomParticles: Enable or disable random glow particles from placed glow sticks.\n  - randomParticleSpawnRate: How often random glow particles spawn (higher = less frequent). Default: 25\n  - spawnWaypointParticles: Enable waypoint particles when sneaking and holding a glow stick to show path to nearest matching glow stick.\n  - waypointSearchRadius: Horizontal radius in blocks to search for nearest glow stick. Default: 32\n  - waypointVerticalSearchRadius: Vertical radius in blocks to search for nearest glow stick. Default: 16\n\n";
    public static int despawnTicks = 2;
    public static boolean spawnRandomParticles = true;
    public static int randomParticleSpawnRate = 25;
    public static boolean spawnWaypointParticles = true;
    public static int waypointSearchRadius = 32;
    public static int waypointVerticalSearchRadius = 16;

    public static void registerConfig() {
        GlowSticksConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        GlowSticksConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = GlowSticksConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = GlowSticksConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        despawnTicks = GlowSticksConfig.parseConfigValue(properties, "despawnTicks", despawnTicks);
        spawnRandomParticles = GlowSticksConfig.parseConfigValue(properties, "spawnRandomParticles", spawnRandomParticles);
        randomParticleSpawnRate = GlowSticksConfig.parseConfigValue(properties, "randomParticleSpawnRate", randomParticleSpawnRate);
        spawnWaypointParticles = GlowSticksConfig.parseConfigValue(properties, "spawnWaypointParticles", spawnWaypointParticles);
        waypointSearchRadius = GlowSticksConfig.parseConfigValue(properties, "waypointSearchRadius", waypointSearchRadius);
        waypointVerticalSearchRadius = GlowSticksConfig.parseConfigValue(properties, "waypointVerticalSearchRadius", waypointVerticalSearchRadius);
        GlowSticksConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

