/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record GlowStickData(boolean activated, int step) {
    public static final String ID = "glow_stick_data";
    public static final String STEP_TAG = "step";
    public static final String ACTIVATED_TAG = "activated";
    public static final GlowStickData EMPTY = new GlowStickData(false, 0);
    public static final ResourceLocation STEP_PREDICATE = ResourceLocation.fromNamespaceAndPath((String)"glow_sticks", (String)"step");
    public static final ResourceLocation ACTIVATED_PREDICATE = ResourceLocation.fromNamespaceAndPath((String)"glow_sticks", (String)"activated");
    public static final Codec<GlowStickData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf(ACTIVATED_TAG).forGetter(GlowStickData::activated), (App)Codec.INT.fieldOf(STEP_TAG).forGetter(GlowStickData::step)).apply((Applicative)instance, GlowStickData::new));
    public static final StreamCodec<ByteBuf, GlowStickData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, GlowStickData::activated, (StreamCodec)ByteBufCodecs.VAR_INT, GlowStickData::step, GlowStickData::new);

    public GlowStickData withActivated(boolean activated) {
        return new GlowStickData(activated, this.step);
    }

    public GlowStickData withStep(int step) {
        return new GlowStickData(this.activated, step);
    }

    public GlowStickData withIncrementedStep() {
        return new GlowStickData(this.activated, this.step + 1);
    }
}

