/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.entity.projectile;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.GlowStickLightBlock;
import de.markusbordihn.glowsticks.block.glowstick.LavaInteraction;
import de.markusbordihn.glowsticks.block.glowstick.PlacementSounds;
import de.markusbordihn.glowsticks.block.glowstick.RedstoneCapable;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GlowStickProjectile
extends ThrowableItemProjectile {
    private static final int TICK_TTL = 650;
    protected final Supplier<Block> lightWaterBlock;
    protected final DyeColor dyeColor;
    protected final Supplier<Item> defaultItem;
    protected final Supplier<Block> lightBlock;
    protected final Supplier<Block> defaultBlock;
    protected Direction defaultDirection = Direction.NORTH;
    private int ticks;

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, level);
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
        if (item != null && item.get() != null) {
            this.setItem(new ItemStack((ItemLike)item.get()));
        }
    }

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, LivingEntity thrower, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, thrower, level, new ItemStack((ItemLike)item.get()));
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultDirection = thrower.getDirection().getOpposite();
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
    }

    public GlowStickProjectile(EntityType<? extends GlowStickProjectile> entityType, Level level, double x, double y, double z, DyeColor dyeColor, Supplier<Block> block, Supplier<Item> item, Supplier<Block> light, Supplier<Block> lightWater) {
        super(entityType, x, y, z, level, new ItemStack((ItemLike)item.get()));
        this.dyeColor = dyeColor;
        this.defaultBlock = block;
        this.defaultItem = item;
        this.lightBlock = light;
        this.lightWaterBlock = lightWater;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    protected Item getDefaultItem() {
        if (this.defaultItem != null) {
            return this.defaultItem.get();
        }
        return Items.STICK;
    }

    private boolean canPlaceBlock(BlockState blockState, BlockPos blockPos) {
        if (blockState.isAir() || blockState.is(Blocks.WATER)) {
            return true;
        }
        if (blockState.canBeReplaced()) {
            return true;
        }
        if (blockState.is(Blocks.SNOW) || blockState.is(Blocks.POWDER_SNOW)) {
            return true;
        }
        if (blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) == 0.0f) {
            return true;
        }
        return !blockState.getFluidState().isEmpty();
    }

    private void dropDefaultItem(Level level, BlockPos blockPos) {
        ItemEntity droppedItem = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)this.getDefaultItem()));
        droppedItem.setDeltaMovement((double)((level.random.nextFloat() - 0.5f) * 0.3f), 0.25, (double)((level.random.nextFloat() - 0.5f) * 0.3f));
        level.addFreshEntity((Entity)droppedItem);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (!this.level().isClientSide) {
            Vec3 location = entityHitResult.getLocation();
            this.dropDefaultItem(this.level(), new BlockPos((int)location.x, (int)location.y, (int)location.z));
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide && this.defaultBlock != null) {
            BlockPos blockPos = blockHitResult.getBlockPos();
            BlockPos placePos = blockPos.relative(blockHitResult.getDirection());
            BlockState targetState = this.level().getBlockState(placePos);
            BlockPos belowPos = placePos.below();
            BlockState belowState = this.level().getBlockState(belowPos);
            if (targetState.getBlock() instanceof GlowStickBlock || belowState.getBlock() instanceof GlowStickBlock) {
                this.dropDefaultItem(this.level(), placePos);
            } else if (this.canPlaceBlock(targetState, placePos)) {
                this.handleGlowStickPlacement(placePos, targetState);
            } else {
                this.dropDefaultItem(this.level(), placePos);
            }
        }
        this.discard();
    }

    private void handleGlowStickPlacement(BlockPos placePos, BlockState targetState) {
        if (LavaInteraction.isLavaBlock(targetState)) {
            this.handleLavaDestruction(placePos);
        } else {
            this.handleNormalPlacement(placePos, targetState);
        }
    }

    private void handleLavaDestruction(BlockPos lavaPos) {
        LavaInteraction.handleLavaDestruction(this.level(), lavaPos);
    }

    private void handleNormalPlacement(BlockPos placePos, BlockState targetState) {
        PlacementSounds.playPlacementSound(this.level(), placePos, targetState, this.random);
        this.placeGlowStickNormally(placePos, targetState);
    }

    private void placeGlowStickNormally(BlockPos placePos, BlockState targetState) {
        boolean isWater = targetState.is(Blocks.WATER) && targetState.getFluidState().getAmount() >= 8;
        BlockState finalState = this.createProjectileGlowStickState(targetState, isWater);
        this.level().setBlockAndUpdate(placePos, finalState);
        RedstoneCapable.handleBlockPlacement(this.level(), placePos, finalState);
    }

    private BlockState createProjectileGlowStickState(BlockState targetState, boolean isWater) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlock.get().defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)this.defaultDirection)).setValue((Property)GlowStickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).setValue((Property)GlowStickBlock.VARIANT, (Comparable)Integer.valueOf(this.random.nextInt(1, 6)));
    }

    public void tick() {
        if (!this.isAlive()) {
            return;
        }
        super.tick();
        if (++this.ticks > 650) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.level().isClientSide && !this.isInWater() && this.ticks % 12 == 0) {
            Vec3 deltaMovement = this.getDeltaMovement();
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() + deltaMovement.x * 0.75, this.getY() + deltaMovement.y * 0.75, this.getZ() + deltaMovement.z * 0.75, deltaMovement.x, deltaMovement.y, deltaMovement.z);
        }
        if (!this.level().isClientSide && this.ticks % 5 == 0) {
            BlockPos lightBlockPosition = this.blockPosition().above();
            BlockState currentBlockState = this.level().getBlockState(lightBlockPosition);
            if (currentBlockState.isAir() || currentBlockState.is(Blocks.WATER)) {
                BlockState newLightBlockState = currentBlockState.is(Blocks.WATER) ? this.lightWaterBlock.get().defaultBlockState() : this.lightBlock.get().defaultBlockState();
                this.level().setBlockAndUpdate(lightBlockPosition, newLightBlockState);
                Block placedBlock = this.level().getBlockState(lightBlockPosition).getBlock();
                if (placedBlock instanceof GlowStickLightBlock) {
                    GlowStickLightBlock glowStickLightBlock = (GlowStickLightBlock)placedBlock;
                    glowStickLightBlock.scheduleTick(this.level(), lightBlockPosition);
                }
            } else {
                Block block = currentBlockState.getBlock();
                if (block instanceof GlowStickLightBlock) {
                    GlowStickLightBlock glowStickLightBlock = (GlowStickLightBlock)block;
                    glowStickLightBlock.scheduleTick(this.level(), lightBlockPosition);
                }
            }
        }
    }
}

