/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.item;

import de.markusbordihn.glowsticks.block.GlowStickBlock;
import de.markusbordihn.glowsticks.block.glowstick.RedstoneCapable;
import de.markusbordihn.glowsticks.utils.ToolTips;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CreativeGlowStickItem
extends Item {
    public static final String NAME = "creative_glow_stick";
    public static final String TOOLTIP_PREFIX = "text.glow_sticks.creative_glow_stick";
    private final Supplier<Block> blockSupplier;
    private final DyeColor dyeColor;

    public CreativeGlowStickItem(Item.Properties properties, Supplier<Block> blockSupplier, DyeColor dyeColor) {
        super(properties);
        this.blockSupplier = blockSupplier;
        this.dyeColor = dyeColor;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (level.isClientSide || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        Block block = clickedState.getBlock();
        if (block instanceof GlowStickBlock) {
            GlowStickBlock existingGlowStick = (GlowStickBlock)block;
            return this.handleGlowStickReplacement(level, clickedPos, clickedState, existingGlowStick, player, itemStack);
        }
        BlockPos placementPos = context.getClickedPos().relative(context.getClickedFace());
        BlockState targetState = level.getBlockState(placementPos);
        Block block2 = targetState.getBlock();
        if (block2 instanceof GlowStickBlock) {
            GlowStickBlock existingGlowStick = (GlowStickBlock)block2;
            return this.handleGlowStickReplacement(level, placementPos, targetState, existingGlowStick, player, itemStack);
        }
        BlockPos belowPos = placementPos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.getBlock() instanceof GlowStickBlock) {
            Block newGlowStickBlock = this.blockSupplier.get();
            if (newGlowStickBlock != null) {
                this.spawnGlowStickItem(level, placementPos, newGlowStickBlock);
                this.consumeItemInSurvival(player, itemStack);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (!targetState.isAir() && !targetState.canBeReplaced()) {
            return InteractionResult.FAIL;
        }
        return this.attemptBlockPlacement(level, placementPos, context, player, itemStack);
    }

    private InteractionResult attemptBlockPlacement(Level level, BlockPos placementPos, UseOnContext context, Player player, ItemStack itemStack) {
        Block glowStickBlock = this.blockSupplier.get();
        if (glowStickBlock == null) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        BlockState proposedState = glowStickBlock.getStateForPlacement(placeContext);
        if (proposedState == null || !this.canPlaceBlockAt(level, placementPos, proposedState)) {
            this.spawnGlowStickItem(level, placementPos, glowStickBlock);
        } else {
            this.placeBlockAndHandleRedstone(level, placementPos, proposedState);
        }
        this.consumeItemInSurvival(player, itemStack);
        return InteractionResult.CONSUME;
    }

    private boolean canPlaceBlockAt(Level level, BlockPos position, BlockState blockState) {
        return blockState.canSurvive((LevelReader)level, position);
    }

    private void placeBlockAndHandleRedstone(Level level, BlockPos position, BlockState blockState) {
        level.setBlockAndUpdate(position, blockState);
        RedstoneCapable.handleBlockPlacement(level, position, blockState);
    }

    private InteractionResult handleGlowStickReplacement(Level level, BlockPos placementPos, BlockState existingState, GlowStickBlock existingGlowStick, Player player, ItemStack itemStack) {
        Block newGlowStickBlock = this.blockSupplier.get();
        if (!(newGlowStickBlock instanceof GlowStickBlock)) {
            return InteractionResult.FAIL;
        }
        GlowStickBlock newGlowStick = (GlowStickBlock)newGlowStickBlock;
        if (newGlowStick.getGlowStickColor() == existingGlowStick.getGlowStickColor()) {
            this.replaceWithNextVariant(level, placementPos, existingState);
            this.consumeItemInSurvival(player, itemStack);
            return InteractionResult.CONSUME;
        }
        int preservedVariant = (Integer)existingState.getValue((Property)GlowStickBlock.VARIANT);
        Direction preservedFacing = (Direction)existingState.getValue(GlowStickBlock.FACING);
        level.removeBlock(placementPos, false);
        return this.placeBlockWithVariantAndFacing(level, placementPos, newGlowStickBlock, preservedVariant, preservedFacing, player, itemStack);
    }

    private InteractionResult placeBlockWithVariantAndFacing(Level level, BlockPos placementPos, Block blockToPlace, int variant, Direction facing, Player player, ItemStack itemStack) {
        BlockState proposedState = (BlockState)((BlockState)blockToPlace.defaultBlockState().setValue((Property)GlowStickBlock.VARIANT, (Comparable)Integer.valueOf(variant))).setValue(GlowStickBlock.FACING, (Comparable)facing);
        if (this.canPlaceBlockAt(level, placementPos, proposedState = RedstoneCapable.getInitialPlacementState(proposedState, level, placementPos))) {
            this.placeBlockAndHandleRedstone(level, placementPos, proposedState);
        } else {
            this.spawnGlowStickItem(level, placementPos, blockToPlace);
        }
        this.consumeItemInSurvival(player, itemStack);
        return InteractionResult.CONSUME;
    }

    private void replaceWithNextVariant(Level level, BlockPos position, BlockState existingState) {
        int currentVariant = (Integer)existingState.getValue((Property)GlowStickBlock.VARIANT);
        level.setBlockAndUpdate(position, (BlockState)existingState.setValue((Property)GlowStickBlock.VARIANT, (Comparable)Integer.valueOf(currentVariant >= 5 ? 0 : currentVariant + 1)));
    }

    private void spawnGlowStickItem(Level level, BlockPos position, Block glowStickBlock) {
        ItemEntity itemEntity = new ItemEntity(level, (double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, new ItemStack((ItemLike)glowStickBlock.asItem()));
        itemEntity.setDeltaMovement((double)((level.random.nextFloat() - 0.5f) * 0.1f), (double)0.2f, (double)((level.random.nextFloat() - 0.5f) * 0.1f));
        level.addFreshEntity((Entity)itemEntity);
    }

    private void consumeItemInSurvival(Player player, ItemStack itemStack) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)("text.glow_sticks.glow_stick_" + String.valueOf(this.dyeColor) + ".description")).withStyle(ChatFormatting.GRAY));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.glow_sticks.creative_glow_stick.usage").withStyle(ChatFormatting.YELLOW));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.glow_sticks.creative_glow_stick.use").withStyle(ChatFormatting.GREEN));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.glow_sticks.creative_glow_stick.permanent").withStyle(ChatFormatting.GOLD));
    }
}

