/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.item;

import de.markusbordihn.glowsticks.component.DataComponents;
import de.markusbordihn.glowsticks.config.GlowSticksConfig;
import de.markusbordihn.glowsticks.data.GlowStickData;
import de.markusbordihn.glowsticks.entity.projectile.GlowStickProjectile;
import de.markusbordihn.glowsticks.utils.ToolTips;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class GlowStickItem
extends Item {
    public static final String NAME = "glow_stick";
    public static final int ANIMATION_STEPS = 6;
    public static final int DURATION_TICKS = 12;
    public static final String TOOLTIP_PREFIX = "text.glow_sticks.glow_stick";
    protected final Supplier<Block> blockSupplier;
    protected final int despawnTickRate;
    private final DyeColor dyeColor;

    public GlowStickItem(Item.Properties properties, Supplier<Block> blockSupplier, DyeColor dyeColor) {
        this(properties, blockSupplier, dyeColor, GlowSticksConfig.despawnTicks);
    }

    public GlowStickItem(Item.Properties properties, Supplier<Block> blockSupplier, DyeColor dyeColor, int despawnTickRate) {
        super(properties);
        this.blockSupplier = blockSupplier;
        this.despawnTickRate = despawnTickRate;
        this.dyeColor = dyeColor;
    }

    public static boolean isActivated(ItemStack stack) {
        GlowStickData glowStickData = (GlowStickData)stack.getOrDefault(DataComponents.GLOW_STICK_DATA, (Object)GlowStickData.EMPTY);
        return glowStickData.activated();
    }

    public static void setActivated(ItemStack stack, boolean activated) {
        GlowStickData currentData = (GlowStickData)stack.getOrDefault(DataComponents.GLOW_STICK_DATA, (Object)GlowStickData.EMPTY);
        stack.set(DataComponents.GLOW_STICK_DATA, (Object)currentData.withActivated(activated));
    }

    public static int getStep(ItemStack itemStack) {
        GlowStickData glowStickData = (GlowStickData)itemStack.getOrDefault(DataComponents.GLOW_STICK_DATA, (Object)GlowStickData.EMPTY);
        return glowStickData.step();
    }

    public static int setStep(ItemStack itemStack, int step) {
        GlowStickData currentData = (GlowStickData)itemStack.getOrDefault(DataComponents.GLOW_STICK_DATA, (Object)GlowStickData.EMPTY);
        itemStack.set(DataComponents.GLOW_STICK_DATA, (Object)currentData.withStep(step));
        return step;
    }

    public static int increaseStep(ItemStack itemStack) {
        GlowStickData currentData = (GlowStickData)itemStack.getOrDefault(DataComponents.GLOW_STICK_DATA, (Object)GlowStickData.EMPTY);
        GlowStickData newData = currentData.withIncrementedStep();
        itemStack.set(DataComponents.GLOW_STICK_DATA, (Object)newData);
        return newData.step();
    }

    public static float getStepFromDataComponent(ItemStack itemStack, Level level, LivingEntity livingEntity, int id) {
        if (itemStack.getItem() instanceof GlowStickItem && livingEntity != null) {
            return GlowStickItem.getStep(itemStack);
        }
        return 0.0f;
    }

    public static float getActivatedFromDataComponent(ItemStack itemStack, Level level, LivingEntity livingEntity, int id) {
        if (itemStack.getItem() instanceof GlowStickItem && livingEntity != null) {
            return GlowStickItem.isActivated(itemStack) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public GlowStickProjectile getGlowStickEntity(Level level, LivingEntity entity) {
        throw new UnsupportedOperationException("GlowStickItem.getGlowStickEntity() not implemented!");
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 12;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.NONE;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (GlowStickItem.isActivated(itemStack)) {
            if (!level.isClientSide) {
                GlowStickProjectile entity = this.getGlowStickEntity(level, (LivingEntity)player);
                entity.setItem(itemStack);
                entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                level.addFreshEntity((Entity)entity);
                player.getCooldowns().addCooldown(itemStack, 12);
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
            }
            GlowStickItem.setActivated(itemStack, false);
            GlowStickItem.setStep(itemStack, 0);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return level.isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int count) {
        if (!level.isClientSide && count % 2 == 0) {
            int step = GlowStickItem.increaseStep(itemStack);
            if (step == 4) {
                level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.TRIDENT_HIT, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (step > 6) {
                GlowStickItem.setStep(itemStack, 0);
            }
        }
    }

    public boolean releaseUsing(ItemStack itemStack, Level level, LivingEntity entity, int timeLeft) {
        return !GlowStickItem.isActivated(itemStack);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity entity) {
        if (!level.isClientSide && !GlowStickItem.isActivated(itemStack)) {
            GlowStickItem.setActivated(itemStack, true);
        }
        return itemStack;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)("text.glow_sticks.glow_stick_" + String.valueOf(this.dyeColor) + ".description")).withStyle(ChatFormatting.GRAY));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.glow_sticks.glow_stick.usage").withStyle(ChatFormatting.YELLOW));
        ToolTips.addTooltip(tooltipConsumer, (Component)Component.translatable((String)"text.glow_sticks.glow_stick.use", (Object[])new Object[]{this.despawnTickRate}).withStyle(ChatFormatting.GREEN));
    }
}

