/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.glowsticks.item;

import de.markusbordihn.glowsticks.item.CreativeGlowStickItemWrapper;
import de.markusbordihn.glowsticks.item.GlowStickItemProperties;
import de.markusbordihn.glowsticks.item.GlowStickItemWrapper;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"glow_sticks");
    protected static final Map<DyeColor, RegistryObject<Item>> GLOW_STICK_ITEMS = new EnumMap<DyeColor, RegistryObject<Item>>(DyeColor.class);
    protected static final Map<DyeColor, RegistryObject<Item>> CREATIVE_GLOW_STICK_ITEMS = new EnumMap<DyeColor, RegistryObject<Item>>(DyeColor.class);

    public static RegistryObject<Item> getGlowStickItem(DyeColor dyeColor) {
        return GLOW_STICK_ITEMS.get(dyeColor);
    }

    public static RegistryObject<Item> getCreativeGlowStickItem(DyeColor dyeColor) {
        return CREATIVE_GLOW_STICK_ITEMS.get(dyeColor);
    }

    static {
        for (DyeColor dyeColor : DyeColor.values()) {
            String colorName = dyeColor.getName();
            String itemName = "glow_stick_" + colorName;
            GLOW_STICK_ITEMS.put(dyeColor, (RegistryObject<Item>)ITEMS.register(itemName, () -> new GlowStickItemWrapper(GlowStickItemProperties.createGlowStickItemProperties(itemName), dyeColor)));
            String creativeItemName = "creative_glow_stick_" + colorName;
            CREATIVE_GLOW_STICK_ITEMS.put(dyeColor, (RegistryObject<Item>)ITEMS.register(creativeItemName, () -> new CreativeGlowStickItemWrapper(GlowStickItemProperties.createGlowStickItemProperties(creativeItemName), dyeColor)));
        }
    }
}

