/*
 * Decompiled with CFR 0.152.
 */
package com.maDU59_.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.maDU59_.config.Option;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_5354;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    public static List<Option> ALL_OPTIONS = new ArrayList<Option>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("ptp.json");
    public static List<Object> ENABLING_OPTION_VALUES = List.of(Boolean.valueOf(true), Boolean.valueOf(false));
    public static List<Object> COLOR_OPTION_VALUES = List.of("Red", "Green", "Blue", "Yellow", "Cyan", "Magenta", "White", "Purple", "Black", "Depends on target");
    public static List<Object> OPACITY_OPTION_VALUES = List.of("Opaque", "Transparent", "Pulsing");
    public static Option SHOW_TRAJECTORY = SettingsManager.loadOptionWithDefaults("SHOW_TRAJECTORY", "Trajectory Preview Visualization", "Toggle the visibility of projectile trajectories.", true, true, ENABLING_OPTION_VALUES);
    public static Option TRAJECTORY_COLOR = SettingsManager.loadOptionWithDefaults("TRAJECTORY_COLOR", "Color", "Select the color of the trajectory line.", "Green", "Green", COLOR_OPTION_VALUES);
    public static Option TRAJECTORY_OPACITY = SettingsManager.loadOptionWithDefaults("TRAJECTORY_OPACITY", "Opacity", "Set the opacity level of the trajectory line.", "Opaque", "Opaque", OPACITY_OPTION_VALUES);
    public static Option TRAJECTORY_STYLE = SettingsManager.loadOptionWithDefaults("TRAJECTORY_STYLE", "Style", "Choose the style of the trajectory line.", "Solid", "Solid", List.of("Solid", "Dashed", "Dotted"));
    public static Option OUTLINE_TARGETS = SettingsManager.loadOptionWithDefaults("OUTLINE_TARGETS", "Outline Targets", "Toggle outlining of potential targets.", true, true, ENABLING_OPTION_VALUES);
    public static Option OUTLINE_COLOR = SettingsManager.loadOptionWithDefaults("OUTLINE_COLOR", "Color", "Select the color for outlining targets.", "Green", "Green", COLOR_OPTION_VALUES);
    public static Option OUTLINE_OPACITY = SettingsManager.loadOptionWithDefaults("OUTLINE_OPACITY", "Opacity", "Set the opacity level of the outline.", "Opaque", "Opaque", OPACITY_OPTION_VALUES);
    public static Option HIGHLIGHT_TARGETS = SettingsManager.loadOptionWithDefaults("HIGHLIGHT_TARGETS", "Highlight Targets", "Toggle highlightning of potential targets.", true, true, ENABLING_OPTION_VALUES);
    public static Option HIGHLIGHT_COLOR = SettingsManager.loadOptionWithDefaults("HIGHLIGHT_COLOR", "Color", "Select the color for highlighting targets.", "Green", "Green", COLOR_OPTION_VALUES);
    public static Option HIGHLIGHT_OPACITY = SettingsManager.loadOptionWithDefaults("HIGHLIGHT_OPACITY", "Opacity", "Set the opacity level of the highlight.", "Transparent", "Transparent", OPACITY_OPTION_VALUES);

    public static List<String> getAllOptionsId() {
        ArrayList<String> list = new ArrayList<String>();
        for (Option option : ALL_OPTIONS) {
            list.add(option.getId());
        }
        return list;
    }

    public static boolean setOptionValue(String optionId, Object value) {
        for (Option option : ALL_OPTIONS) {
            System.out.println(optionId + ": " + option.getId() + ", " + option.getId().equalsIgnoreCase(optionId));
            System.out.println(String.valueOf(value) + ": " + String.valueOf(option.getPossibleValues()) + ", " + option.getPossibleValues().contains(value));
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            int index = option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList()).indexOf((String)value);
            if (option.getPossibleValues().contains(value)) {
                option.setValue(value);
                return true;
            }
            if (index == -1) continue;
            option.setValue(option.getPossibleValues().get(index));
            return true;
        }
        return false;
    }

    public static List<String> getOptionPossibleValues(String optionId) {
        for (Option option : ALL_OPTIONS) {
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            return option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }

    public static int getARGBColorFromSetting(String colorName, String opacitySetting, class_1297 entity) {
        int[] colors = SettingsManager.getColorFromSetting(colorName, entity);
        return colors[2] + colors[1] * 256 + colors[0] * 256 * 256 + SettingsManager.getAlphaFromSetting(opacitySetting) * 256 * 256 * 256;
    }

    public static int getAlphaFromSetting(String opacitySetting) {
        return switch (opacitySetting) {
            case "Opaque" -> 255;
            case "Transparent" -> 100;
            case "Pulsing" -> (int)Math.floor(Math.sin((double)(System.currentTimeMillis() % 2000L) / 2000.0 * Math.PI) * 206.0) + 50;
            default -> 255;
        };
    }

    public static float[] convertColorToFloat(int[] colors) {
        float red = (float)colors[0] / 255.0f;
        float green = (float)colors[1] / 255.0f;
        float blue = (float)colors[2] / 255.0f;
        return new float[]{red, green, blue};
    }

    public static float convertAlphaToFloat(int alpha) {
        float alphaFloat = (float)alpha / 255.0f;
        return alphaFloat;
    }

    public static int[] getColorFromSetting(String colorName) {
        return SettingsManager.getColorFromSetting(colorName, null);
    }

    public static int[] getColorFromSetting(String colorName, class_1297 entity) {
        if (colorName.equals("Depends on target")) {
            colorName = entity == null ? "White" : (entity instanceof class_1657 ? "Blue" : (entity instanceof class_5354 ? "Yellow" : (entity instanceof class_1296 ? "Green" : (entity instanceof class_1588 ? "Red" : (entity instanceof class_1308 ? "Purple" : (entity instanceof class_1309 ? "Cyan" : "Magenta"))))));
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        switch (colorName) {
            case "Red": {
                red = 255;
                break;
            }
            case "Green": {
                green = 255;
                break;
            }
            case "Blue": {
                blue = 255;
                break;
            }
            case "Yellow": {
                red = 255;
                green = 255;
                break;
            }
            case "Cyan": {
                green = 255;
                blue = 255;
                break;
            }
            case "Magenta": {
                red = 255;
                blue = 255;
                break;
            }
            case "White": {
                red = 255;
                green = 255;
                blue = 255;
                break;
            }
            case "Black": {
                red = 0;
                green = 0;
                blue = 0;
                break;
            }
            case "Purple": {
                red = 128;
                green = 0;
                blue = 128;
                break;
            }
            default: {
                red = 255;
            }
        }
        return new int[]{red, green, blue};
    }

    public static void saveSettings(List<Option> options) {
        Map<String, Option> map = SettingsManager.toMap(options);
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Option> toMap(List<Option> options) {
        LinkedHashMap<String, Option> map = new LinkedHashMap<String, Option>();
        for (Option option : options) {
            map.put(option.getId(), option);
        }
        return map;
    }

    private static Option loadOption(String key) {
        Option option;
        block8: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                Type type = new TypeToken<Map<String, Option>>(){}.getType();
                Map map = (Map)GSON.fromJson((Reader)reader, type);
                option = (Option)map.get(key);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return option;
    }

    private static Option loadOptionWithDefaults(String id, String name, String description, Object value, Object defaultValue, List<Object> possibleValues) {
        Option loadedOption = SettingsManager.loadOption(id);
        System.out.println("Loaded option for " + id + ": " + (loadedOption == null ? "null" : loadedOption.getValueAsString()));
        if (loadedOption == null) {
            return new Option(id, name, description, value, defaultValue, possibleValues);
        }
        loadedOption.setPossibleValues(possibleValues);
        ALL_OPTIONS.add(loadedOption);
        return loadedOption;
    }
}

