/*
 * Decompiled with CFR 0.152.
 */
package com.maDU59_.config;

import com.maDU59_.config.SettingsManager;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Option {
    public String id;
    public String name;
    public String description;
    public Object value;
    public Object defaultValue;
    public List<Object> possibleValues;

    public Option(String id, String name, String description, Object value, Object defaultValue, List<Object> possibleValues) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.value = value;
        this.defaultValue = defaultValue;
        this.possibleValues = possibleValues;
        SettingsManager.ALL_OPTIONS.add(this);
    }

    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public Object getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public String getValueAsString() {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean boolValue = (Boolean)object;
            return boolValue != false ? "Enabled" : "Disabled";
        }
        return this.value.toString();
    }

    public void setToNextValue() {
        if (this.possibleValues != null && !this.possibleValues.isEmpty()) {
            int currentIndex = this.possibleValues.indexOf(this.value);
            int nextIndex = (currentIndex + 1) % this.possibleValues.size();
            this.value = this.possibleValues.get(nextIndex);
        }
    }
}

