/*
 * Decompiled with CFR 0.152.
 */
package com.maDU59_;

import com.maDU59_.HandshakeNetworking;
import com.maDU59_.ProjectileInfo;
import com.maDU59_.config.ClientCommands;
import com.maDU59_.config.SettingsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9974;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ptpClient
implements ClientModInitializer {
    private static final class_310 client = class_310.method_1551();
    public static final Logger LOGGER = LogManager.getLogger((String)"ptpClient");
    private static boolean serverHasMod = false;

    public void onInitializeClient() {
        ClientCommands.register();
        PayloadTypeRegistry.playS2C().register(HandshakeNetworking.HANDSHAKE_S2CPayload.ID, HandshakeNetworking.HANDSHAKE_S2CPayload.CODEC);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            serverHasMod = false;
            if (client.method_1496()) {
                serverHasMod = true;
                return;
            }
            ClientPlayNetworking.send((class_8710)new HandshakeNetworking.HANDSHAKE_C2SPayload("Check if is installed on server"));
            System.out.println("[PTP] Sending handshake to server...");
        });
        ClientPlayNetworking.registerGlobalReceiver(HandshakeNetworking.HANDSHAKE_S2CPayload.ID, (payload, context) -> {
            System.out.println("[PTP] Received handshake from server...");
            serverHasMod = true;
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_238 entityBoundingBox;
            class_2338 impactPos;
            class_3965 blockHitResult;
            class_243 pos;
            class_746 player = ptpClient.client.field_1724;
            if (player == null || !ptpClient.isEnabled()) {
                return;
            }
            class_1792 item = player.method_6047().method_7909();
            ProjectileInfo projectileInfo = ProjectileInfo.getItemsInfo(item, (class_1657)player);
            if (!projectileInfo.isReadyToShoot) {
                return;
            }
            class_243 eye = player.method_33571();
            class_243 vel = projectileInfo.initialVelocity.method_1019(player.method_18798());
            class_243 prevPos = pos = eye;
            class_243 handToEyeDelta = this.GetHandToEyeDelta((class_1657)player, projectileInfo.offset, context);
            class_3965 impact = null;
            class_1297 entityImpact = null;
            boolean hasHit = false;
            ArrayList<class_243> trajectoryPoints = new ArrayList<class_243>();
            for (int i = 0; i < 200; ++i) {
                trajectoryPoints.add(pos);
                pos = pos.method_1019(vel);
                vel = vel.method_1021(projectileInfo.drag).method_1023(0.0, projectileInfo.gravity, 0.0);
                class_238 box = new class_238(prevPos, pos).method_1014(1.0);
                List entities = ptpClient.client.field_1687.method_8390(class_1297.class, box, e -> !e.method_7325() && e.method_5805() && !(e instanceof class_1676));
                class_1297 closest = null;
                double closestDistance = 99999.0;
                class_243 entityHitPos = null;
                for (class_1297 entity : entities) {
                    double distance;
                    class_238 entityBox = entity.method_5829().method_1014((double)entity.method_5871());
                    Optional entityRaycastHit = entityBox.method_992(prevPos, pos);
                    if (!entityRaycastHit.isPresent() || !((distance = prevPos.method_1025((class_243)entityRaycastHit.get())) < closestDistance)) continue;
                    entityHitPos = (class_243)entityRaycastHit.get();
                    closest = entity;
                    closestDistance = distance;
                }
                class_3965 hit = player.method_37908().method_17742(new class_3959(prevPos, pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                if (hit.method_17783() != class_239.class_240.field_1333 && prevPos.method_1025(hit.method_17784()) < closestDistance) {
                    impact = hit;
                    pos = hit.method_17784();
                    trajectoryPoints.add(pos);
                    hasHit = true;
                    break;
                }
                if (entityHitPos != null) {
                    entityImpact = closest;
                    pos = entityHitPos;
                    trajectoryPoints.add(pos);
                    hasHit = true;
                    break;
                }
                prevPos = pos;
            }
            class_243 cam = context.camera().method_19326();
            if (((Boolean)SettingsManager.HIGHLIGHT_TARGETS.getValue()).booleanValue()) {
                if (impact != null && impact.method_17783() == class_239.class_240.field_1332 && impact instanceof class_3965) {
                    blockHitResult = impact;
                    impactPos = blockHitResult.method_17777();
                    ptpClient.renderFilled(context, impactPos.method_10263(), impactPos.method_10264(), impactPos.method_10260(), impactPos.method_10263() + 1, impactPos.method_10264() + 1, impactPos.method_10260() + 1, SettingsManager.convertColorToFloat(SettingsManager.getColorFromSetting((String)SettingsManager.HIGHLIGHT_COLOR.getValue())), SettingsManager.convertAlphaToFloat(SettingsManager.getAlphaFromSetting((String)SettingsManager.HIGHLIGHT_OPACITY.getValue())));
                } else if (entityImpact != null) {
                    entityBoundingBox = entityImpact.method_5829().method_1014((double)entityImpact.method_5871());
                    ptpClient.renderFilled(context, entityBoundingBox.field_1323, entityBoundingBox.field_1322, entityBoundingBox.field_1321, entityBoundingBox.field_1320, entityBoundingBox.field_1325, entityBoundingBox.field_1324, SettingsManager.convertColorToFloat(SettingsManager.getColorFromSetting((String)SettingsManager.HIGHLIGHT_COLOR.getValue())), SettingsManager.convertAlphaToFloat(SettingsManager.getAlphaFromSetting((String)SettingsManager.HIGHLIGHT_OPACITY.getValue())));
                }
            }
            if (((Boolean)SettingsManager.OUTLINE_TARGETS.getValue()).booleanValue()) {
                if (impact != null && impact.method_17783() == class_239.class_240.field_1332 && impact instanceof class_3965) {
                    blockHitResult = impact;
                    impactPos = blockHitResult.method_17777();
                    ptpClient.renderBox(context, impactPos.method_10263(), impactPos.method_10264(), impactPos.method_10260(), impactPos.method_10263() + 1, impactPos.method_10264() + 1, impactPos.method_10260() + 1, SettingsManager.convertColorToFloat(SettingsManager.getColorFromSetting((String)SettingsManager.OUTLINE_COLOR.getValue())), SettingsManager.convertAlphaToFloat(SettingsManager.getAlphaFromSetting((String)SettingsManager.OUTLINE_OPACITY.getValue())));
                } else if (entityImpact != null) {
                    entityBoundingBox = entityImpact.method_5829().method_1014((double)entityImpact.method_5871());
                    ptpClient.renderBox(context, entityBoundingBox.field_1323, entityBoundingBox.field_1322, entityBoundingBox.field_1321, entityBoundingBox.field_1320, entityBoundingBox.field_1325, entityBoundingBox.field_1324, SettingsManager.convertColorToFloat(SettingsManager.getColorFromSetting((String)SettingsManager.OUTLINE_COLOR.getValue())), SettingsManager.convertAlphaToFloat(SettingsManager.getAlphaFromSetting((String)SettingsManager.OUTLINE_OPACITY.getValue())));
                }
            }
            class_4587 matrices = context.matrixStack();
            class_4588 lineConsumer = context.consumers().getBuffer(class_1921.method_23594());
            if (((Boolean)SettingsManager.SHOW_TRAJECTORY.getValue()).booleanValue()) {
                matrices.method_22903();
                matrices.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
                for (int i = 0; i < trajectoryPoints.size() - 1; ++i) {
                    class_243 lerpedDelta = handToEyeDelta.method_1021(((double)trajectoryPoints.size() - (double)i * 1.0) / (double)trajectoryPoints.size());
                    class_243 nextLerpedDelta = handToEyeDelta.method_1021(((double)trajectoryPoints.size() - ((double)i + 1.0)) / (double)trajectoryPoints.size());
                    pos = ((class_243)trajectoryPoints.get(i)).method_1019(lerpedDelta);
                    int color = SettingsManager.getARGBColorFromSetting((String)SettingsManager.TRAJECTORY_COLOR.getValue(), (String)SettingsManager.TRAJECTORY_OPACITY.getValue());
                    class_243 dir = ((class_243)trajectoryPoints.get(i + 1)).method_1019(nextLerpedDelta).method_1020(pos);
                    if (SettingsManager.TRAJECTORY_STYLE.getValueAsString() == "Dashed") {
                        dir = dir.method_1021(0.5);
                    } else if (SettingsManager.TRAJECTORY_STYLE.getValueAsString() == "Dotted") {
                        dir = dir.method_1021(0.15);
                    }
                    Vector3f floatPos = new Vector3f((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
                    class_9974.method_62298((class_4587)matrices, (class_4588)lineConsumer, (Vector3f)floatPos, (class_243)dir, (int)color);
                }
                matrices.method_22909();
            }
            if (hasHit) {
                matrices.method_22903();
                matrices.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
                pos = (class_243)trajectoryPoints.getLast();
                double r = 0.1;
                double x = pos.field_1352;
                double y = pos.field_1351;
                double z = pos.field_1350;
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)(x - r), (float)y, (float)z).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)(x + r), (float)y, (float)z).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)(y - r), (float)z).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)(y + r), (float)z).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, (float)(z - r)).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, (float)(z + r)).method_1336(255, 0, 0, 255).method_22914(0.0f, 1.0f, 0.0f);
                matrices.method_22909();
            }
        });
    }

    private class_243 GetHandToEyeDelta(class_1657 player, class_243 offset, WorldRenderContext context) {
        float yaw = (float)Math.toRadians(-player.method_5705(1.0f));
        float pitch = (float)Math.toRadians(-player.method_5695(1.0f));
        class_243 forward = player.method_5828(1.0f);
        class_243 up = new class_243(-Math.sin(pitch) * Math.sin(yaw), Math.cos(pitch), -Math.sin(pitch) * Math.cos(yaw)).method_1029();
        class_243 right = forward.method_1036(up).method_1029();
        return right.method_1021(offset.field_1352).method_1019(up.method_1021(offset.field_1351)).method_1019(forward.method_1021(offset.field_1350)).method_1019(context.camera().method_19326().method_1020(player.method_33571()));
    }

    private static void renderFilled(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4588 quadConsumer = context.consumers().getBuffer(class_1921.method_49047());
        class_9974.method_62300((class_4587)matrices, (class_4588)quadConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    private static void renderBox(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4588 quadConsumer = context.consumers().getBuffer(class_1921.method_34572());
        class_9974.method_62292((class_4587)matrices, (class_4588)quadConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    public static boolean isEnabled() {
        class_310 client = class_310.method_1551();
        return client.method_1496() || serverHasMod;
    }
}

