/*
 * Decompiled with CFR 0.152.
 */
package com.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.utils.Prefix;
import com.utils.fetch;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoTo {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"goto").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            return GoTo.handleGoToCommand(name, class_310.method_1551());
        }))));
    }

    private static int handleGoToCommand(String townName, class_310 client) {
        if (client.field_1724 == null) {
            LOGGER.error("Player instance is null, cannot send feedback.");
            return 0;
        }
        CompletableFuture.runAsync(() -> {
            try {
                int radius = 500;
                for (int maxAttempts = 3; maxAttempts > 0; --maxAttempts) {
                    fetch fetchInstance = new fetch();
                    JsonObject payload = new JsonObject();
                    JsonArray queryArray = new JsonArray();
                    JsonObject query = new JsonObject();
                    query.addProperty("target_type", "TOWN");
                    query.addProperty("target", townName);
                    query.addProperty("search_type", "TOWN");
                    query.addProperty("radius", (Number)radius);
                    queryArray.add((JsonElement)query);
                    payload.add("query", (JsonElement)queryArray);
                    String apiUrl = "https://api.earthmc.net/v3/aurora/nearby";
                    String UnparsedResponse = fetchInstance.Fetch(apiUrl, payload.toString());
                    JsonArray response = JsonParser.parseString((String)UnparsedResponse).getAsJsonArray().get(0).getAsJsonArray();
                    ArrayList<String> validTowns = new ArrayList<String>();
                    JsonArray towns = new JsonArray();
                    for (JsonElement element : response) {
                        JsonObject town = element.getAsJsonObject();
                        String townNameFromResponse = town.get("name").getAsString();
                        towns.add(townNameFromResponse);
                    }
                    JsonObject townDetailsPayload = new JsonObject();
                    townDetailsPayload.add("query", (JsonElement)towns);
                    JsonObject template = new JsonObject();
                    template.addProperty("name", Boolean.valueOf(true));
                    template.addProperty("status", Boolean.valueOf(true));
                    townDetailsPayload.add("template", (JsonElement)template);
                    String townDetailsUrl = "https://api.earthmc.net/v3/aurora/towns/";
                    String townDetailsResponse = fetchInstance.Fetch(townDetailsUrl, townDetailsPayload.toString());
                    JsonArray townDetailsArray = JsonParser.parseString((String)townDetailsResponse).getAsJsonArray();
                    for (JsonElement townDetailElement : townDetailsArray) {
                        JsonObject townDetail = townDetailElement.getAsJsonObject();
                        JsonObject status = townDetail.get("status").getAsJsonObject();
                        if (status.get("isPublic").getAsBoolean() && status.get("canOutsidersSpawn").getAsBoolean()) {
                            validTowns.add(townDetail.get("name").getAsString());
                            continue;
                        }
                        if (!status.get("isCapital").getAsBoolean()) continue;
                        String nationUuid = townDetail.get("nation").getAsJsonObject().get("uuid").getAsString();
                        JsonObject nationDetailsPayload = new JsonObject();
                        JsonArray nationQueryArray = new JsonArray();
                        nationQueryArray.add(nationUuid);
                        nationDetailsPayload.add("query", (JsonElement)nationQueryArray);
                        String nationDetailsUrl = "https://api.earthmc.net/v3/aurora/nations/";
                        JsonObject nationDetails = JsonParser.parseString((String)fetchInstance.Fetch(nationDetailsUrl, nationDetailsPayload.toString())).getAsJsonObject();
                        if (!nationDetails.has("isPublic") || !nationDetails.get("status").getAsJsonObject().get("isPublic").getAsBoolean()) continue;
                        validTowns.add(townDetail.get("name").getAsString());
                    }
                    if (validTowns.size() >= 1) {
                        client.execute(() -> GoTo.sendMessage(client, (class_2561)class_2561.method_43470((String)("Found suitable spawn in: " + validTowns.toString())).method_10862(class_2583.field_24360.method_10977(class_124.field_1060))));
                        return;
                    }
                    radius += 500;
                }
                client.execute(() -> GoTo.sendMessage(client, (class_2561)class_2561.method_43470((String)"No suitable spawns found.").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))));
            }
            catch (Exception e) {
                e.printStackTrace();
                client.execute(() -> GoTo.sendMessage(client, (class_2561)class_2561.method_43470((String)"Command exited with an exception.").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))));
                LOGGER.error("Command exited with an exception: " + e.getMessage());
            }
        });
        return 1;
    }

    private static void sendMessage(class_310 client, class_2561 message) {
        client.execute(() -> {
            if (client.field_1724 != null) {
                class_2561 prefix = Prefix.getPrefix();
                class_5250 chatMessage = class_2561.method_43470((String)"").method_10852(prefix).method_10852(message);
                client.field_1724.method_7353((class_2561)chatMessage, false);
            }
        });
    }
}

