/*
 * Decompiled with CFR 0.152.
 */
package com.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.utils.Prefix;
import com.utils.fetch;
import com.utils.timestamps;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class lastSeen {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder command = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"lastSeen").then(RequiredArgumentBuilder.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String username = StringArgumentType.getString((CommandContext)context, (String)"username");
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null) {
                    LOGGER.error("Player instance is null, cannot send feedback.");
                    return 0;
                }
                CompletableFuture.runAsync(() -> {
                    try {
                        JsonObject payload = new JsonObject();
                        JsonObject template = new JsonObject();
                        template.addProperty("timestamps", Boolean.valueOf(true));
                        template.addProperty("status", Boolean.valueOf(true));
                        JsonArray queryArray = new JsonArray();
                        queryArray.add(username);
                        payload.add("query", (JsonElement)queryArray);
                        payload.add("template", (JsonElement)template);
                        String response = new fetch().Fetch("https://api.earthmc.net/v3/aurora/players", payload.toString());
                        JsonElement element = JsonParser.parseString((String)response);
                        if (!element.isJsonArray()) {
                            LOGGER.error("Expected JSON Array but got: " + response);
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Unexpected response format").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
                            return;
                        }
                        JsonArray parsedResponse = element.getAsJsonArray();
                        JsonObject timestamps2 = parsedResponse.get(0).getAsJsonObject().get("timestamps").getAsJsonObject();
                        long lastOnline = timestamps2.get("lastOnline").getAsLong();
                        List<Long> offlineDate = new timestamps().parseTimestamp(lastOnline);
                        JsonElement online = parsedResponse.get(0).getAsJsonObject().get("status").getAsJsonObject().get("isOnline");
                        if (!online.getAsBoolean()) {
                            String statusMessage = String.format("%s has been offline for %d days, %d hours, and %d minutes.", username, offlineDate.get(0), offlineDate.get(1), offlineDate.get(2));
                            class_5250 formattedMessage = class_2561.method_43470((String)statusMessage).method_27692(class_124.field_1061);
                            client.execute(() -> lastSeen.lambda$register$0(client, (class_2561)formattedMessage));
                        } else {
                            String statusMessage = String.format("%s is currently online, for %d days, %d hours, and %d minutes.", username, offlineDate.get(0), offlineDate.get(1), offlineDate.get(2));
                            class_5250 formattedMessage = class_2561.method_43470((String)statusMessage).method_27692(class_124.field_1060);
                            client.execute(() -> lastSeen.lambda$register$1(client, (class_2561)formattedMessage));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Command has exited with an exception").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
                        LOGGER.error("Command has exited with an exception: " + e.getMessage());
                    }
                });
                return 1;
            }));
            dispatcher.register(command);
        });
    }

    private static void sendMessage(class_310 client, class_2561 message) {
        client.execute(() -> {
            if (client.field_1724 != null) {
                class_2561 prefix = Prefix.getPrefix();
                class_5250 chatMessage = class_2561.method_43470((String)"").method_10852(prefix).method_10852(message);
                client.field_1724.method_7353((class_2561)chatMessage, false);
            }
        });
    }

    private static /* synthetic */ void lambda$register$1(class_310 client, class_2561 formattedMessage) {
        lastSeen.sendMessage(client, formattedMessage);
    }

    private static /* synthetic */ void lambda$register$0(class_310 client, class_2561 formattedMessage) {
        lastSeen.sendMessage(client, formattedMessage);
    }
}

