/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.types.Nation;
import net.chariskar.breakthemod.types.Town;
import net.chariskar.breakthemod.utils.config;

public class GoToService
extends Service {
    private static final ExecutorService IO_EXECUTOR = Executors.newFixedThreadPool(4);

    public CompletableFuture<List<String>> findValidTowns(String townName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<String> valid = new ArrayList<String>();
                Town reqTown = this.fetch.getTown(townName);
                if (reqTown.getStatus().get().isCapital.booleanValue()) {
                    String nationUuid = reqTown.getNation().get().getName().get();
                    Nation nation = this.fetch.getNation(nationUuid);
                    if (nation.getStatus().get().isPublic.booleanValue()) {
                        valid.add(reqTown.getName());
                    }
                    return valid;
                }
                if (reqTown.getStatus().get().isPublic.booleanValue() && reqTown.getStatus().get().canOutsidersSpawn.booleanValue()) {
                    valid.add(reqTown.getName());
                    return valid;
                }
                int radius = 500;
                int attempts = 3;
                while (attempts-- > 0) {
                    JsonObject payload = new JsonObject();
                    JsonArray queryArr = new JsonArray();
                    JsonObject query = new JsonObject();
                    query.addProperty("target_type", "TOWN");
                    query.addProperty("target", townName);
                    query.addProperty("search_type", "TOWN");
                    query.addProperty("radius", (Number)radius);
                    queryArr.add((JsonElement)query);
                    payload.add("query", (JsonElement)queryArr);
                    String nearbyUrl = config.getInstance().getApiURL() + "/nearby";
                    String nearbyResp = this.fetch.PostRequest(nearbyUrl, payload.toString()).body();
                    JsonArray nearbyArray = JsonParser.parseString((String)nearbyResp).getAsJsonArray().get(0).getAsJsonArray();
                    ArrayList<String> names = new ArrayList<String>();
                    for (JsonElement el : nearbyArray) {
                        JsonObject obj = el.getAsJsonObject();
                        if (!obj.has("name")) continue;
                        names.add(obj.get("name").getAsString());
                    }
                    if (names.isEmpty()) {
                        radius += 500;
                        continue;
                    }
                    List<Town> towns = this.fetch.getTowns(names);
                    for (Town town : towns) {
                        Town.Status status = town.getStatus().get();
                        if (status.isPublic.booleanValue() && status.canOutsidersSpawn.booleanValue()) {
                            valid.add(town.getName());
                            continue;
                        }
                        if (!status.isCapital.booleanValue()) continue;
                        String nationUuid = town.getNation().get().getName().get();
                        Nation nation = this.fetch.getNation(nationUuid);
                        if (!nation.getStatus().get().isPublic.booleanValue()) continue;
                        valid.add(town.getName());
                    }
                    if (!valid.isEmpty()) {
                        return valid;
                    }
                    radius += 500;
                }
                return Collections.emptyList();
            }
            catch (Exception e) {
                this.logError("Unexpected error occurred while fetching location", e);
                throw new RuntimeException(e);
            }
        }, IO_EXECUTOR);
    }
}

