/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Optional;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.utils.config;

public class coordsService
extends Service {
    private final Gson gson = new Gson();

    public LocationResult get(double x, double z) throws Exception {
        JsonArray coords2 = new JsonArray();
        coords2.add((Number)x);
        coords2.add((Number)z);
        JsonArray queryArray = new JsonArray();
        queryArray.add((JsonElement)coords2);
        JsonObject payload = new JsonObject();
        payload.add("query", (JsonElement)queryArray);
        String resp = this.fetch.PostRequest(config.getInstance().getApiURL() + "location", payload.toString()).body();
        JsonArray data = JsonParser.parseString((String)resp).getAsJsonArray();
        if (data.size() != 1 || !data.get(0).isJsonObject()) {
            throw new JsonParseException("Unexpected API response format: " + resp);
        }
        JsonObject obj = data.get(0).getAsJsonObject();
        boolean isWilderness = obj.has("isWilderness") && obj.get("isWilderness").getAsBoolean();
        Optional<String> townName = Optional.empty();
        Optional<String> nationName = Optional.empty();
        if (!isWilderness) {
            JsonObject nation;
            JsonObject town;
            if (obj.has("town") && obj.get("town").isJsonObject() && (town = obj.getAsJsonObject("town")).has("name")) {
                townName = Optional.of(town.get("name").getAsString());
            }
            if (obj.has("nation") && obj.get("nation").isJsonObject() && (nation = obj.getAsJsonObject("nation")).has("name")) {
                nationName = Optional.of(nation.get("name").getAsString());
            }
        }
        return new LocationResult(isWilderness, townName, nationName);
    }

    public record LocationResult(boolean wilderness, Optional<String> townName, Optional<String> nationName) {
        @Override
        public String toString() {
            return "LocationResult{wilderness=" + this.wilderness + ", townName=" + String.valueOf(this.townName) + ", nationName=" + String.valueOf(this.nationName) + "}";
        }

        public String format() {
            StringBuilder sb = new StringBuilder();
            if (this.wilderness) {
                sb.append("Coordinates are in the wilderness.");
            } else {
                sb.append("Coordinates are in").append(this.townName.orElse("no town."));
                this.nationName.ifPresent(s -> sb.append(", part of the nation of ").append((String)s));
                sb.append(".");
            }
            return sb.toString();
        }
    }
}

