/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.utils.config;

public class discordLinkedService
extends Service {
    public String get(String username) {
        try {
            String mojangResponse = this.fetch.GetRequest("https://api.mojang.com/users/profiles/minecraft/" + username).body();
            JsonObject mojangData = JsonParser.parseString((String)mojangResponse).getAsJsonObject();
            String rawUUID = mojangData.get("id").getAsString();
            String formattedUUID = this.formatUUID(rawUUID);
            if (!this.isValidUUID(formattedUUID)) {
                return null;
            }
            JsonObject payload = new JsonObject();
            JsonArray queryArray = new JsonArray();
            JsonObject queryItem = new JsonObject();
            queryItem.addProperty("type", "minecraft");
            queryItem.addProperty("target", formattedUUID);
            queryArray.add((JsonElement)queryItem);
            payload.add("query", (JsonElement)queryArray);
            String emcResponse = this.fetch.PostRequest(config.getInstance().getApiURL() + "/discord", payload.toString()).body();
            JsonArray result = JsonParser.parseString((String)emcResponse).getAsJsonArray();
            if (result.isEmpty()) {
                return null;
            }
            JsonObject first = result.get(0).getAsJsonObject();
            return first.get("id").getAsString();
        }
        catch (Exception e) {
            LOGGER.error("Error while resolving Discord ID for '{}': {}", new Object[]{username, e.getMessage(), e});
            return null;
        }
    }

    private String formatUUID(String uuid) {
        return uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20);
    }

    private boolean isValidUUID(String uuid) {
        return uuid.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }
}

