/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.api.Fetch;
import net.chariskar.breakthemod.utils.config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class locateService
extends Service {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");
    private final Fetch fetchInstance = Fetch.getInstance();

    public LocationResult getLocation(String name, LocationType type) {
        try {
            JsonObject payload = this.buildPayload(name);
            String response = this.fetchInstance.PostRequest(type.getApiUrl(), payload.toString()).body();
            JsonArray responseArray = JsonParser.parseString((String)response).getAsJsonArray();
            if (responseArray.isEmpty()) {
                return null;
            }
            JsonObject coordinates = responseArray.get(0).getAsJsonObject().get("coordinates").getAsJsonObject().get("spawn").getAsJsonObject();
            int x = coordinates.get("x").getAsInt();
            int z = coordinates.get("z").getAsInt();
            return new LocationResult(name, x, z);
        }
        catch (Exception e) {
            this.logError("Unexpected error occurred while fetching location", e);
            return null;
        }
    }

    private JsonObject buildPayload(String name) {
        JsonObject payload = new JsonObject();
        JsonArray queryArray = new JsonArray();
        queryArray.add(name);
        payload.add("query", (JsonElement)queryArray);
        JsonObject template = new JsonObject();
        template.addProperty("coordinates", Boolean.valueOf(true));
        payload.add("template", (JsonElement)template);
        return payload;
    }

    public static enum LocationType {
        TOWN(config.getInstance().getApiURL() + "towns"),
        NATION(config.getInstance().getApiURL() + "nations");

        private final String apiUrl;

        private LocationType(String apiUrl) {
            this.apiUrl = apiUrl;
        }

        public static LocationType fromString(String type) {
            return switch (type.toLowerCase()) {
                case "town" -> TOWN;
                case "nation" -> NATION;
                default -> throw new IllegalArgumentException("Invalid type: " + type + ". Use 'town' or 'nation'.");
            };
        }

        public String getApiUrl() {
            return this.apiUrl;
        }
    }

    public static class LocationResult {
        private final String name;
        private final int x;
        private final int z;
        private final String mapUrl;

        public LocationResult(String name, int x, int z) {
            this.name = name;
            this.x = x;
            this.z = z;
            this.mapUrl = String.format("%s?world=minecraft_overworld&zoom=3&x=%d&z=%d", config.getInstance().getMapURL(), x, z);
        }

        public String getName() {
            return this.name;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public String getMapUrl() {
            return this.mapUrl;
        }
    }
}

