/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.types.Resident;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class townlessService
extends Service {
    private static final int BATCH_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");

    public List<String> get(List<?> onlinePlayers) {
        List ids = onlinePlayers.stream().map(Object::toString).collect(Collectors.toList());
        try {
            if (ids.size() == 1) {
                Resident resident = this.fetch.getResident((String)ids.getFirst());
                if (resident != null && resident.getTown().isPresent()) {
                    return Collections.singletonList(resident.getTown().get().getName().get());
                }
                return null;
            }
            ArrayList<String> townless2 = new ArrayList<String>();
            for (int i = 0; i < ids.size(); i += 100) {
                int end = Math.min(i + 100, ids.size());
                List<String> batch = ids.subList(i, end);
                List<Resident> residents = this.fetch.getResidents(batch);
                townless2.addAll(residents.stream().filter(res -> res.getStatus().isPresent() && res.getStatus().get().getHasTown().get() == false).map(Resident::getName).toList());
            }
            return townless2;
        }
        catch (Exception e) {
            this.logError("Error fetching townless players", e);
            return null;
        }
    }
}

