/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.chariskar.breakthemod.utils.config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command<S> {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUsageSuffix();

    public final String getUsage() {
        return "/" + this.getName() + (String)(this.getUsageSuffix().isEmpty() ? "" : " " + this.getUsageSuffix());
    }

    protected abstract int execute(CommandContext<S> var1) throws Exception;

    protected abstract int run(CommandContext<S> var1) throws CommandSyntaxException;

    public abstract void register(CommandDispatcher<S> var1);

    public static String getConnectedServerAddress() {
        return null;
    }

    public static boolean getEnabled() {
        return false;
    }

    protected void logError(String message, Exception e) {
        LOGGER.error("{}{}", (Object)message, (Object)e.getMessage());
        if (config.getInstance().isDev()) {
            e.printStackTrace();
        }
    }
}

