/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.chariskar.breakthemod.types.Nation;
import net.chariskar.breakthemod.types.Resident;
import net.chariskar.breakthemod.types.Town;
import net.chariskar.breakthemod.types.reference;
import net.chariskar.breakthemod.utils.config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fetch {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");
    private static final Fetch INSTANCE = new Fetch();
    private final Gson gson = new Gson();

    private Fetch() {
    }

    public static Fetch getInstance() {
        return INSTANCE;
    }

    public Town getTown(String name) {
        return this.getTowns(name).getFirst();
    }

    public List<Town> getTowns(List<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<Town>();
        }
        return this.getObjects("towns", names, Town.class);
    }

    public List<Town> getTowns(String ... names) {
        return this.getTowns(Arrays.asList(names));
    }

    public Nation getNation(String name) {
        return this.getNations(name).getFirst();
    }

    public List<Nation> getNations(List<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<Nation>();
        }
        return this.getObjects("nations", names, Nation.class);
    }

    public List<Nation> getNations(String ... names) {
        return this.getNations(Arrays.asList(names));
    }

    public Resident getResident(String name) {
        return this.getResidents(Collections.singletonList(name)).getFirst();
    }

    public List<Resident> getResidents(List<String> names) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<Resident>();
        }
        return this.getObjects("players", names, Resident.class);
    }

    public List<reference> getAllTowns() {
        return this.getAll("towns", reference.class);
    }

    public List<reference> getAllNations() {
        return this.getAll("nations", reference.class);
    }

    public List<reference> getAllPlayers() {
        return this.getAll("players", reference.class);
    }

    public <T> List<T> getAll(String endpoint, Class<T> T) {
        try {
            HttpResponse<String> rawResponse = this.GetRequest(config.getInstance().getApiURL() + endpoint);
            if (rawResponse.statusCode() != 200 | rawResponse.body().isEmpty()) {
                return null;
            }
            String response = rawResponse.body();
            JsonArray responseArray = JsonParser.parseString((String)response).getAsJsonArray();
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement element : responseArray) {
                Object obj = this.gson.fromJson((JsonElement)element.getAsJsonObject(), T);
                results.add(obj);
            }
            return results;
        }
        catch (Exception e) {
            this.logError("Unexpected error occurred while trying to access web resource", e);
            return null;
        }
    }

    public <T> List<T> getObjects(String endpoint, List<String> names, Class<T> type) {
        if (names == null || names.isEmpty()) {
            return new ArrayList();
        }
        JsonObject payload = new JsonObject();
        JsonArray query = new JsonArray();
        names.forEach(arg_0 -> ((JsonArray)query).add(arg_0));
        payload.add("query", (JsonElement)query);
        try {
            HttpResponse<String> rawResponse = this.PostRequest(config.getInstance().getApiURL() + endpoint, payload.toString());
            if (rawResponse.statusCode() != 200) {
                if (rawResponse.statusCode() == 500) {
                    return new ArrayList();
                }
                LOGGER.error("Unexpected error occurred while sending request. status code {}", (Object)rawResponse.statusCode());
                return null;
            }
            String response = rawResponse.body();
            if (response.isEmpty()) {
                return Collections.emptyList();
            }
            JsonArray responseArray = JsonParser.parseString((String)response).getAsJsonArray();
            if (responseArray.isEmpty()) {
                return null;
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement element : responseArray) {
                try {
                    Object obj = this.gson.fromJson((JsonElement)element.getAsJsonObject(), type);
                    results.add(obj);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to parse object of type {} from response: {}", (Object)type.getSimpleName(), (Object)e.getMessage());
                }
            }
            return results;
        }
        catch (Exception e) {
            this.logError("Unexpected error occurred while fetching", e);
            return new ArrayList();
        }
    }

    private void logError(String message, Exception e) {
        LOGGER.error("{}{}", (Object)message, (Object)e.getMessage());
        if (config.getInstance().isDev()) {
            e.printStackTrace();
        }
    }

    public HttpResponse<String> PostRequest(String url, String payload) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.formatUrl(url))).header("Content-Type", "application/json");
        requestBuilder.POST(HttpRequest.BodyPublishers.ofString(payload));
        HttpRequest request = requestBuilder.build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public HttpResponse<String> GetRequest(String url) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.formatUrl(url))).header("Content-Type", "application/json");
        requestBuilder.GET();
        HttpRequest request = requestBuilder.build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private String formatUrl(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        int protocolEnd = url.indexOf("://");
        if (protocolEnd == -1) {
            return url;
        }
        String protocol = url.substring(0, protocolEnd + 3);
        String rest = url.substring(protocolEnd + 3);
        if ((rest = rest.replaceAll("/{2,}", "/")).endsWith("/") && rest.length() > 1) {
            rest = rest.substring(0, rest.length() - 1);
        }
        return protocol + rest;
    }
}

