/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.fabric.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.chariskar.breakthemod.Services.GoToService;
import net.chariskar.breakthemod.fabric.client.commands.FabricCommand;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class GoTo
extends FabricCommand {
    private final GoToService Service = new GoToService();

    @Override
    public String getName() {
        return "goto";
    }

    @Override
    public String getDescription() {
        return "Tells you in which town to spawn in so you are the closest to the town you want to go to";
    }

    @Override
    public String getUsageSuffix() {
        return "<destination>";
    }

    @Override
    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)this.getName()).then(RequiredArgumentBuilder.argument((String)"destination", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (!GoTo.getEnabled()) {
                return 0;
            }
            return this.run((CommandContext<FabricClientCommandSource>)context);
        })));
    }

    @Override
    protected int execute(CommandContext<FabricClientCommandSource> ctx) throws Exception {
        String destination = (String)ctx.getArgument("destination", String.class);
        class_310 client = class_310.method_1551();
        if (!GoTo.getEnabled()) {
            return 0;
        }
        ((CompletableFuture)this.Service.findValidTowns(destination).thenAcceptAsync(output -> client.execute(() -> {
            if (output.isEmpty()) {
                this.sendMessage(client, (class_2561)class_2561.method_43470((String)"No suitable spawns found").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            } else {
                this.sendMessage(client, (class_2561)class_2561.method_43470((String)("Found suitable spawn for " + destination + " in: " + String.join((CharSequence)", ", output))).method_10862(class_2583.field_24360.method_10977(class_124.field_1075)));
            }
        }), (Executor)client)).exceptionally(ex -> {
            client.execute(() -> this.sendMessage(client, (class_2561)class_2561.method_43470((String)("Error finding towns: " + ex.getMessage())).method_10862(class_2583.field_24360.method_10977(class_124.field_1061))));
            return null;
        });
        return 1;
    }
}

