/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.types;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.chariskar.breakthemod.types.reference;

public class Town {
    public String name;
    public UUID uuid;
    public String board;
    public String founder;
    public String wiki;
    public Mayor mayor;
    public Nation nation;
    public Timestamps timestamps;
    public Status status;
    public Stats stats;
    public Perms perms;
    public Coordinates coordinates;
    public List<Resident> residents;
    public List<Resident> trusted;
    public List<Resident> outlaws;
    public List<reference> quarters;
    public Ranks ranks;

    public Town(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<UUID> getUuid() {
        return Optional.ofNullable(this.uuid);
    }

    public Optional<String> getBoard() {
        return Optional.ofNullable(this.board);
    }

    public Optional<String> getFounder() {
        return Optional.ofNullable(this.founder);
    }

    public Optional<String> getWiki() {
        return Optional.ofNullable(this.wiki);
    }

    public Optional<Mayor> getMayor() {
        return Optional.ofNullable(this.mayor);
    }

    public Optional<Nation> getNation() {
        return Optional.ofNullable(this.nation);
    }

    public Optional<Timestamps> getTimestamps() {
        return Optional.ofNullable(this.timestamps);
    }

    public Optional<Status> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<Stats> getStats() {
        return Optional.ofNullable(this.stats);
    }

    public Optional<Perms> getPerms() {
        return Optional.ofNullable(this.perms);
    }

    public Optional<Coordinates> getCoordinates() {
        return Optional.ofNullable(this.coordinates);
    }

    public Optional<List<Resident>> getResidents() {
        return Optional.ofNullable(this.residents);
    }

    public Optional<List<Resident>> getTrusted() {
        return Optional.ofNullable(this.trusted);
    }

    public Optional<List<Resident>> getOutlaws() {
        return Optional.ofNullable(this.outlaws);
    }

    public Optional<List<reference>> getQuarters() {
        return Optional.ofNullable(this.quarters);
    }

    public Optional<Ranks> getRanks() {
        return Optional.ofNullable(this.ranks);
    }

    public static class Mayor {
        public String name;
        public UUID uuid;

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<UUID> getUuid() {
            return Optional.ofNullable(this.uuid);
        }
    }

    public static class Nation {
        public String name;
        public UUID uuid;

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<UUID> getUuid() {
            return Optional.ofNullable(this.uuid);
        }
    }

    public static class Timestamps {
        public Long registered;
        public Long joinedNationAt;
        public Long ruinedAt;

        public Optional<Long> getRegistered() {
            return Optional.ofNullable(this.registered);
        }

        public Optional<Long> getJoinedNationAt() {
            return Optional.ofNullable(this.joinedNationAt);
        }

        public Optional<Long> getRuinedAt() {
            return Optional.ofNullable(this.ruinedAt);
        }
    }

    public static class Status {
        public Boolean isPublic;
        public Boolean isOpen;
        public Boolean isNeutral;
        public Boolean isCapital;
        public Boolean isOverClaimed;
        public Boolean isRuined;
        public Boolean isForSale;
        public Boolean hasNation;
        public Boolean hasOverclaimShield;
        public Boolean canOutsidersSpawn;

        public Optional<Boolean> getIsPublic() {
            return Optional.ofNullable(this.isPublic);
        }

        public Optional<Boolean> getIsOpen() {
            return Optional.ofNullable(this.isOpen);
        }

        public Optional<Boolean> getIsNeutral() {
            return Optional.ofNullable(this.isNeutral);
        }

        public Optional<Boolean> getIsCapital() {
            return Optional.ofNullable(this.isCapital);
        }

        public Optional<Boolean> getIsOverClaimed() {
            return Optional.ofNullable(this.isOverClaimed);
        }

        public Optional<Boolean> getIsRuined() {
            return Optional.ofNullable(this.isRuined);
        }

        public Optional<Boolean> getIsForSale() {
            return Optional.ofNullable(this.isForSale);
        }

        public Optional<Boolean> getHasNation() {
            return Optional.ofNullable(this.hasNation);
        }

        public Optional<Boolean> getHasOverclaimShield() {
            return Optional.ofNullable(this.hasOverclaimShield);
        }

        public Optional<Boolean> getCanOutsidersSpawn() {
            return Optional.ofNullable(this.canOutsidersSpawn);
        }
    }

    public static class Stats {
        public Integer numTownBlocks;
        public Integer maxTownBlocks;
        public Integer numResidents;
        public Integer numTrusted;
        public Integer numOutlaws;
        public Integer balance;
        public Integer forSalePrice;

        public Optional<Integer> getNumTownBlocks() {
            return Optional.ofNullable(this.numTownBlocks);
        }

        public Optional<Integer> getMaxTownBlocks() {
            return Optional.ofNullable(this.maxTownBlocks);
        }

        public Optional<Integer> getNumResidents() {
            return Optional.ofNullable(this.numResidents);
        }

        public Optional<Integer> getNumTrusted() {
            return Optional.ofNullable(this.numTrusted);
        }

        public Optional<Integer> getNumOutlaws() {
            return Optional.ofNullable(this.numOutlaws);
        }

        public Optional<Integer> getBalance() {
            return Optional.ofNullable(this.balance);
        }

        public Optional<Integer> getForSalePrice() {
            return Optional.ofNullable(this.forSalePrice);
        }
    }

    public static class Perms {
        public List<Boolean> build;
        public List<Boolean> destroy;
        public List<Boolean> switchPerm;
        public List<Boolean> itemUse;
        public Flags flags;

        public Optional<List<Boolean>> getBuild() {
            return Optional.ofNullable(this.build);
        }

        public Optional<List<Boolean>> getDestroy() {
            return Optional.ofNullable(this.destroy);
        }

        public Optional<List<Boolean>> getSwitchPerm() {
            return Optional.ofNullable(this.switchPerm);
        }

        public Optional<List<Boolean>> getItemUse() {
            return Optional.ofNullable(this.itemUse);
        }

        public Optional<Flags> getFlags() {
            return Optional.ofNullable(this.flags);
        }
    }

    public static class Coordinates {
        public Spawn spawn;
        public List<Integer> homeBlock;
        public List<List<Integer>> townBlocks;

        public Optional<Spawn> getSpawn() {
            return Optional.ofNullable(this.spawn);
        }

        public Optional<List<Integer>> getHomeBlock() {
            return Optional.ofNullable(this.homeBlock);
        }

        public Optional<List<List<Integer>>> getTownBlocks() {
            return Optional.ofNullable(this.townBlocks);
        }
    }

    public static class Ranks {
        public List<Resident> Councillor;
        public List<Resident> Builder;
        public List<Resident> Recruiter;
        public List<Resident> Police;
        public List<Resident> TaxExempt;
        public List<Resident> Treasurer;
        public List<Resident> Realtor;
        public List<Resident> Settler;

        public Optional<List<Resident>> getCouncillor() {
            return Optional.ofNullable(this.Councillor);
        }

        public Optional<List<Resident>> getBuilder() {
            return Optional.ofNullable(this.Builder);
        }

        public Optional<List<Resident>> getRecruiter() {
            return Optional.ofNullable(this.Recruiter);
        }

        public Optional<List<Resident>> getPolice() {
            return Optional.ofNullable(this.Police);
        }

        public Optional<List<Resident>> getTaxExempt() {
            return Optional.ofNullable(this.TaxExempt);
        }

        public Optional<List<Resident>> getTreasurer() {
            return Optional.ofNullable(this.Treasurer);
        }

        public Optional<List<Resident>> getRealtor() {
            return Optional.ofNullable(this.Realtor);
        }

        public Optional<List<Resident>> getSettler() {
            return Optional.ofNullable(this.Settler);
        }
    }

    public static class Resident {
        public String name;
        public UUID uuid;

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<UUID> getUuid() {
            return Optional.ofNullable(this.uuid);
        }
    }

    public static class Spawn {
        public String world;
        public Double x;
        public Integer y;
        public Double z;
        public Float pitch;
        public Float yaw;

        public Optional<String> getWorld() {
            return Optional.ofNullable(this.world);
        }

        public Optional<Double> getX() {
            return Optional.ofNullable(this.x);
        }

        public Optional<Integer> getY() {
            return Optional.ofNullable(this.y);
        }

        public Optional<Double> getZ() {
            return Optional.ofNullable(this.z);
        }

        public Optional<Float> getPitch() {
            return Optional.ofNullable(this.pitch);
        }

        public Optional<Float> getYaw() {
            return Optional.ofNullable(this.yaw);
        }
    }

    public static class Flags {
        public Boolean pvp;
        public Boolean explosion;
        public Boolean fire;
        public Boolean mobs;

        public Optional<Boolean> getPvp() {
            return Optional.ofNullable(this.pvp);
        }

        public Optional<Boolean> getExplosion() {
            return Optional.ofNullable(this.explosion);
        }

        public Optional<Boolean> getFire() {
            return Optional.ofNullable(this.fire);
        }

        public Optional<Boolean> getMobs() {
            return Optional.ofNullable(this.mobs);
        }
    }
}

