/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.chariskar.breakthemod.api.Fetch;
import net.chariskar.breakthemod.utils.config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class bestdealsService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");
    private static final Pattern PARSER = Pattern.compile("Shop\\{id=(\\d+), owner='([^']+)', item='([^']+)', price=([\\d.]+), type='([^']+)', space=(\\d+), stock=(-?\\d+)\\}");
    private final Gson gson = new Gson();
    private Fetch fetchInstance = Fetch.getInstance();

    public List<Shop> get(String itemName, String nationName) {
        List<Shop> shops = Collections.emptyList();
        try {
            shops = new ArrayList<Shop>(this.parseShops(JsonParser.parseString((String)this.fetchInstance.GetRequest(config.getInstance().getApiURL() + "/shops").body()).getAsJsonArray()));
            shops.removeIf(s -> s.getType().equalsIgnoreCase("SELLING"));
            shops.removeIf(s -> !s.matches(itemName));
            shops.sort(Comparator.comparingDouble(Shop::getPrice));
        }
        catch (Exception e) {
            if (config.getInstance().isDev()) {
                e.printStackTrace();
            }
            LOGGER.error("Unexpected Error Occurred", (Throwable)e);
        }
        return shops;
    }

    public List<Shop> parseShops(JsonArray resp) {
        return resp.asList().stream().map(raw -> Shop.fromString(raw.getAsString())).toList();
    }

    public static class Shop {
        private final int id;
        private final UUID owner;
        private final String item;
        private final double price;
        private final String type;
        private final int space;
        private final int stock;

        public Shop(int id, UUID owner, String item, double price, String type, int space, int stock) {
            this.id = id;
            this.owner = owner;
            this.item = item;
            this.price = price;
            this.type = type;
            this.space = space;
            this.stock = stock;
        }

        public static Shop fromString(String input) {
            Matcher m = PARSER.matcher(input.trim());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid Shop string: " + input);
            }
            int id = Integer.parseInt(m.group(1));
            UUID owner = UUID.fromString(m.group(2));
            String item = m.group(3);
            double price = Double.parseDouble(m.group(4));
            String type = m.group(5);
            int space = Integer.parseInt(m.group(6));
            int stock = Integer.parseInt(m.group(7));
            return new Shop(id, owner, item, price, type, space, stock);
        }

        public double getPrice() {
            return this.price;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public String getType() {
            return this.type;
        }

        public boolean matches(String query) {
            query = query.toLowerCase();
            return String.valueOf(this.id).contains(query) || this.item.toLowerCase().contains(query) || String.valueOf(this.price).contains(query) || this.type.toLowerCase().contains(query) || String.valueOf(this.space).contains(query) || String.valueOf(this.stock).contains(query);
        }

        public String toString() {
            return String.format("Shop{id=%d, owner='%s', item='%s', price=%f, type='%s', space=%d, stock=%d}", this.id, this.owner, this.item, this.price, this.type, this.space, this.stock);
        }
    }
}

