/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Optional;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.utils.config;

public class findPlayerService
extends Service {
    public Optional<PlayerLocationInfo> get(String username) {
        try {
            String playersJson = this.fetch.GetRequest(config.getInstance().getApiURL() + "tiles/players.json").body();
            JsonObject playersObject = JsonParser.parseString((String)playersJson).getAsJsonObject();
            JsonArray playersArray = playersObject.getAsJsonArray("players");
            for (JsonElement playerElement : playersArray) {
                JsonObject user = playerElement.getAsJsonObject();
                String name = user.get("name").getAsString();
                if (!name.equalsIgnoreCase(username)) continue;
                double x = user.get("x").getAsDouble();
                double z = user.get("z").getAsDouble();
                JsonObject payload = new JsonObject();
                JsonArray queryArray = new JsonArray();
                JsonArray coords2 = new JsonArray();
                coords2.add((Number)x);
                coords2.add((Number)z);
                queryArray.add((JsonElement)coords2);
                payload.add("query", (JsonElement)queryArray);
                String locationJson = this.fetch.PostRequest(config.getInstance().getApiURL() + "/location", payload.toString()).body();
                JsonArray locationData = JsonParser.parseString((String)locationJson).getAsJsonArray();
                if (locationData.isEmpty() || !locationData.get(0).isJsonObject()) continue;
                JsonObject data = locationData.get(0).getAsJsonObject();
                boolean isWilderness = data.get("isWilderness").getAsBoolean();
                String townName = "Unknown";
                if (!isWilderness && data.has("town") && data.get("town").isJsonObject()) {
                    JsonObject town = data.getAsJsonObject("town");
                    townName = town.has("name") ? town.get("name").getAsString() : "Unknown";
                }
                return Optional.of(new PlayerLocationInfo(username, x, z, isWilderness, townName, true));
            }
            return Optional.of(new PlayerLocationInfo(username, 0.0, 0.0, true, "N/A", false));
        }
        catch (Exception e) {
            System.err.println("Error fetching location for " + username + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    public static class PlayerLocationInfo {
        public final String username;
        public final double x;
        public final double z;
        public final boolean isWilderness;
        public final String townName;
        public boolean found = false;

        public PlayerLocationInfo(String username, double x, double z, boolean isWilderness, String townName, boolean found) {
            this.username = username;
            this.x = x;
            this.z = z;
            this.isWilderness = isWilderness;
            this.townName = townName;
            this.found = found;
        }

        public String toString() {
            if (!this.found) {
                return this.username + " is either offline or not showing up on the map.";
            }
            if (this.isWilderness) {
                return this.username + " at x: " + this.x + ", z: " + this.z + " is in wilderness.";
            }
            return this.username + " at x: " + this.x + ", z: " + this.z + " is in town: " + this.townName + ".";
        }
    }
}

