/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.Services;

import java.util.List;
import net.chariskar.breakthemod.Services.Service;
import net.chariskar.breakthemod.types.Resident;
import net.chariskar.breakthemod.utils.timestamps;

public class lastSeenService
extends Service {
    private final timestamps timestampParser = new timestamps();

    public String get(String username) {
        try {
            Resident resident = this.fetch.getResident(username);
            if (resident == null) {
                return String.format("Player '%s' not found", username);
            }
            long lastOnline = resident.getTimestamps().get().getLastOnline().get();
            boolean isOnline = resident.getStatus().get().getIsOnline().get();
            List<Long> offlineParts = timestamps.parseTimestamp(lastOnline);
            long days = offlineParts.get(0);
            long hours = offlineParts.get(1);
            long minutes = offlineParts.get(2);
            if (!isOnline) {
                return String.format("%s has been offline for %d days, %d hours, and %d minutes.", username, days, hours, minutes);
            }
            return String.format("%s is currently online, for %d days, %d hours, and %d minutes.", username, days, hours, minutes);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching status for '{}': {}", new Object[]{username, e.getMessage(), e});
            return "An error occurred while fetching player status.";
        }
    }
}

