/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class nearby {
    private static final long UPDATE_INTERVAL_MS = 1000L;
    private static final double DISTANCE_THRESHOLD = 200.0;
    private static final String[] DIRECTIONS = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    private static final double DIRECTION_STEP = 45.0;
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final List<String> playerInfoList = new ArrayList<String>();
    private final StringBuilder stringBuilder = new StringBuilder(256);

    public synchronized Set<String> updateNearbyPlayers(Player self, World world2) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime.get() < 1000L) {
            return new HashSet<String>(this.playerInfoList);
        }
        this.lastUpdateTime.set(currentTime);
        this.playerInfoList.clear();
        Vec3 selfPos = self.getPosition();
        String selfName = self.getName();
        for (Player other : world2.getPlayers()) {
            int z;
            int y;
            int x;
            Vec3 otherPos;
            double distanceSquared;
            if (other == self || Objects.equals(other.getName(), selfName) || this.shouldSkipPlayer(other) || (distanceSquared = selfPos.distanceToSquared(otherPos = other.getPosition())) > 40000.0 || this.isPlayerUnderBlock(world2, x = (int)Math.floor(otherPos.x()), y = (int)Math.floor(otherPos.y()), z = (int)Math.floor(otherPos.z()))) continue;
            double distance = Math.sqrt(distanceSquared);
            String direction = this.getDirectionFromYaw(other.getYaw());
            this.stringBuilder.setLength(0);
            this.stringBuilder.append("- ").append(other.getName()).append(" (").append(x).append(", ").append(z).append(") direction: ").append(direction).append(", distance: ").append(String.format("%.1f", distance)).append(" blocks");
            this.playerInfoList.add(this.stringBuilder.toString());
        }
        if (this.playerInfoList.isEmpty()) {
            this.playerInfoList.add("No players nearby");
        }
        return new HashSet<String>(this.playerInfoList);
    }

    private boolean shouldSkipPlayer(Player player2) {
        return player2.isInvisible() || player2.isSneaking() || player2.isInVehicle() || player2.isInNether() || player2.isInRiptideAnimation();
    }

    private boolean isPlayerUnderBlock(World world2, int x, int y, int z) {
        int topY = world2.getTopY(x, z);
        if (y >= topY) {
            return false;
        }
        for (int currentY = y + 1; currentY <= topY; ++currentY) {
            if (world2.isBlockAirAt(x, currentY, z)) continue;
            return true;
        }
        return false;
    }

    private String getDirectionFromYaw(float yaw) {
        yaw = ((yaw + 180.0f) % 360.0f + 360.0f) % 360.0f;
        int directionIndex = (int)Math.round((double)yaw / 45.0) % 8;
        return DIRECTIONS[directionIndex];
    }

    public static interface Player {
        public String getName();

        public Vec3 getPosition();

        public float getYaw();

        public boolean isInvisible();

        public boolean isInRiptideAnimation();

        public boolean isInNether();

        public boolean isInVehicle();

        public boolean isSneaking();
    }

    public record Vec3(double x, double y, double z) {
        public double distanceToSquared(Vec3 other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            double dz = this.z - other.z;
            return dx * dx + dy * dy + dz * dz;
        }

        public double distanceTo(Vec3 other) {
            return Math.sqrt(this.distanceToSquared(other));
        }
    }

    public static interface World {
        public Iterable<Player> getPlayers();

        public boolean isBlockAirAt(int var1, int var2, int var3);

        public int getTopY(int var1, int var2);
    }
}

