/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.types;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.chariskar.breakthemod.types.reference;

public class Resident {
    private final String name;
    private UUID uuid;
    private String title;
    private String surname;
    private String formattedName;
    private String about;
    private reference town;
    private reference nation;
    private Timestamps timestamps;
    private Status status;
    private Stats stats;
    private Perms perms;
    private Ranks ranks;
    private List<reference> friends;

    public Resident(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Optional<UUID> getUuid() {
        return Optional.ofNullable(this.uuid);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getSurname() {
        return Optional.ofNullable(this.surname);
    }

    public Optional<String> getFormattedName() {
        return Optional.ofNullable(this.formattedName);
    }

    public Optional<String> getAbout() {
        return Optional.ofNullable(this.about);
    }

    public Optional<reference> getTown() {
        return Optional.ofNullable(this.town);
    }

    public Optional<reference> getNation() {
        return Optional.ofNullable(this.nation);
    }

    public Optional<Timestamps> getTimestamps() {
        return Optional.ofNullable(this.timestamps);
    }

    public Optional<Status> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<Stats> getStats() {
        return Optional.ofNullable(this.stats);
    }

    public Optional<Perms> getPerms() {
        return Optional.ofNullable(this.perms);
    }

    public Optional<Ranks> getRanks() {
        return Optional.ofNullable(this.ranks);
    }

    public Optional<List<reference>> getFriends() {
        return Optional.ofNullable(this.friends);
    }

    public static class Timestamps {
        public Long registered;
        public Long joinedTownAt;
        public Long lastOnline;

        public Optional<Long> getRegistered() {
            return Optional.ofNullable(this.registered);
        }

        public Optional<Long> getJoinedTownAt() {
            return Optional.ofNullable(this.joinedTownAt);
        }

        public Optional<Long> getLastOnline() {
            return Optional.ofNullable(this.lastOnline);
        }
    }

    public static class Status {
        private Boolean isOnline;
        private Boolean isNPC;
        private Boolean isMayor;
        private Boolean isKing;
        private Boolean hasTown;
        private Boolean hasNation;

        public Optional<Boolean> getIsOnline() {
            return Optional.ofNullable(this.isOnline);
        }

        public Optional<Boolean> getIsNPC() {
            return Optional.ofNullable(this.isNPC);
        }

        public Optional<Boolean> getIsMayor() {
            return Optional.ofNullable(this.isMayor);
        }

        public Optional<Boolean> getIsKing() {
            return Optional.ofNullable(this.isKing);
        }

        public Optional<Boolean> getHasTown() {
            return Optional.ofNullable(this.hasTown);
        }

        public Optional<Boolean> getHasNation() {
            return Optional.ofNullable(this.hasNation);
        }
    }

    public static class Stats {
        public Integer balance;
        public Integer numFriends;

        public Optional<Integer> getBalance() {
            return Optional.ofNullable(this.balance);
        }

        public Optional<Integer> getNumFriends() {
            return Optional.ofNullable(this.numFriends);
        }
    }

    public static class Perms {
        public List<Boolean> build;
        public List<Boolean> destroy;
        @SerializedName(value="switch")
        public List<Boolean> switchPerm;
        public List<Boolean> itemUse;
        public Flags flags;

        public Optional<List<Boolean>> getBuild() {
            return Optional.ofNullable(this.build);
        }

        public Optional<List<Boolean>> getDestroy() {
            return Optional.ofNullable(this.destroy);
        }

        public Optional<List<Boolean>> getSwitchPerm() {
            return Optional.ofNullable(this.switchPerm);
        }

        public Optional<List<Boolean>> getItemUse() {
            return Optional.ofNullable(this.itemUse);
        }

        public Optional<Flags> getFlags() {
            return Optional.ofNullable(this.flags);
        }
    }

    public static class Ranks {
        public List<String> townRanks;
        public List<String> nationRanks;

        public Optional<List<String>> getTownRanks() {
            return Optional.ofNullable(this.townRanks);
        }

        public Optional<List<String>> getNationRanks() {
            return Optional.ofNullable(this.nationRanks);
        }
    }

    public static class Flags {
        public Boolean pvp;
        public Boolean explosion;
        public Boolean fire;
        public Boolean mobs;

        public Optional<Boolean> getPvp() {
            return Optional.ofNullable(this.pvp);
        }

        public Optional<Boolean> getExplosion() {
            return Optional.ofNullable(this.explosion);
        }

        public Optional<Boolean> getFire() {
            return Optional.ofNullable(this.fire);
        }

        public Optional<Boolean> getMobs() {
            return Optional.ofNullable(this.mobs);
        }
    }
}

