/*
 * Decompiled with CFR 0.152.
 */
package net.chariskar.breakthemod.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class config {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"breakthemod");
    private static final Gson gson = new Gson();
    public static Boolean dev = false;
    private static config instance = null;
    private static final File configFile = new File(Platform.getConfigFolder().toFile(), "breakthemod_config.json");
    private static String API_URL = "https://api.earthmc.net/v3/aurora";
    private static String MAP_URL = "https://map.earthmc.com/";
    private static String Staff_Repo_Url = "https://raw.githubusercontent.com/jwkerr/staff/master/staff.json";
    public boolean radarEnabled = true;
    private WidgetPosition widgetPosition = WidgetPosition.TOP_LEFT;
    private int customX = 0;
    private int customY = 0;
    private boolean enabledOnOtherServers = false;

    private config() {
        this.loadConfig();
    }

    public static config getInstance() {
        if (instance == null) {
            instance = new config();
            return instance;
        }
        return instance;
    }

    public File getConfigFile() {
        return configFile;
    }

    public WidgetPosition getWidgetPosition() {
        return this.widgetPosition;
    }

    public void setWidgetPosition(WidgetPosition position) {
        this.widgetPosition = position;
    }

    public int getCustomX() {
        return this.customX;
    }

    public void setCustomX(int x) {
        this.customX = x;
    }

    public int getCustomY() {
        return this.customY;
    }

    public void setCustomY(int y) {
        this.customY = y;
    }

    public boolean getRadarEnabled() {
        return this.radarEnabled;
    }

    public void setRadarEnabled(boolean enabled) {
        this.radarEnabled = enabled;
    }

    public boolean isEnabledOnOtherServers() {
        return this.enabledOnOtherServers;
    }

    public void setEnabledOnOtherServers(boolean enabled) {
        this.enabledOnOtherServers = enabled;
    }

    public boolean isDev() {
        return dev;
    }

    public void setDev(boolean bl) {
        dev = bl;
    }

    public String getApiURL() {
        return this.formatURL(API_URL);
    }

    public void setApiURL(String url) {
        API_URL = this.formatURL(url);
    }

    public String getMapURL() {
        return this.formatURL(MAP_URL);
    }

    public void setMapUrl(String url) {
        MAP_URL = this.formatURL(url);
    }

    public void setStaffRepoURL(String url) {
        Staff_Repo_Url = this.formatURL(url);
    }

    public String getStaffRepoURL() {
        return this.formatURL(Staff_Repo_Url);
    }

    public void saveConfig() {
        JsonObject configJson = new JsonObject();
        configJson.addProperty("widgetPosition", this.widgetPosition.name());
        configJson.addProperty("customX", (Number)this.customX);
        configJson.addProperty("customY", (Number)this.customY);
        configJson.addProperty("radarEnabled", Boolean.valueOf(this.radarEnabled));
        configJson.addProperty("enabledOnOtherServers", Boolean.valueOf(this.enabledOnOtherServers));
        configJson.addProperty("dev", dev);
        configJson.addProperty("API_URL", API_URL);
        configJson.addProperty("MAP_URL", MAP_URL);
        configJson.addProperty("STAFF_REPO_URL", MAP_URL);
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((JsonElement)configJson, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected I/O exception: {}", (Object)e.getMessage());
        }
    }

    private void loadConfig() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject configJson = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                this.widgetPosition = configJson.has("widgetPosition") ? WidgetPosition.valueOf(configJson.get("widgetPosition").getAsString()) : WidgetPosition.TOP_LEFT;
                this.customX = configJson.has("customX") ? configJson.get("customX").getAsInt() : 0;
                this.customY = configJson.has("customY") ? configJson.get("customY").getAsInt() : 0;
                this.radarEnabled = !configJson.has("radarEnabled") || configJson.get("radarEnabled").getAsBoolean();
                this.enabledOnOtherServers = configJson.has("enabledOnOtherServers") && configJson.get("enabledOnOtherServers").getAsBoolean();
                dev = configJson.has("dev") ? configJson.get("dev").getAsBoolean() : dev.booleanValue();
                API_URL = configJson.has("API_URL") ? configJson.get("API_URL").getAsString() : API_URL;
                MAP_URL = configJson.has("MAP_URL") ? configJson.get("MAP_URL").getAsString() : MAP_URL;
                Staff_Repo_Url = configJson.has("STAFF_REPO_URL") ? configJson.get("STAFF_REPO_URL").getAsString() : Staff_Repo_Url;
            }
            catch (IOException e) {
                LOGGER.error("Unexpected I/O exception: {}", (Object)e.getMessage());
            }
        }
    }

    private String formatURL(String url) {
        if (!((String)url).startsWith("https://")) {
            url = "https://" + (String)url;
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    public static enum WidgetPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        CUSTOM;

    }
}

