/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.util.Triple;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2035;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_227;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_72;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_85;
import net.minecraft.class_8548;
import net.minecraft.class_8551;
import net.minecraft.class_93;
import net.minecraft.class_9334;
import net.minecraft.class_9356;

public class LootTableHelper {
    public static List<LootEntry> entriesInTable(class_2960 tableIdentifier, Function<class_2960, class_52> lookup) {
        return LootTableHelper.entriesInTable(lookup.apply(tableIdentifier), lookup);
    }

    private static List<LootEntry> entriesInTable(class_52 table, Function<class_2960, class_52> lookup) {
        ArrayList<LootEntry> items = new ArrayList();
        for (class_55 pool : table.field_943) {
            float rolls = LootTableHelper.averageValue(pool.field_957);
            int totalWeight = pool.field_953.stream().mapToInt(LootTableHelper::containerWeight).sum();
            pool.field_953.stream().flatMap(container -> LootTableHelper.itemsFromContainer(container, totalWeight, lookup)).map(entry -> entry.withChance(1.0 - Math.pow(1.0 - entry.chance, rolls))).forEach(items::add);
        }
        items = new ArrayList(items.stream().collect(Collectors.toMap(entry -> Triple.of((Object)entry.stack.method_7909(), (Object)entry.stack.method_57380(), (Object)Pair.of((Object)entry.stack.method_7947(), entry.conditions)), Function.identity(), (first, second) -> first.withChance(1.0 - (1.0 - first.chance) * (1.0 - second.chance)))).values());
        return items;
    }

    private static int containerWeight(class_79 container) {
        if (container instanceof class_85) {
            return ((class_85)container).field_995;
        }
        if (container instanceof class_65) {
            return ((class_65)container).field_982.stream().mapToInt(LootTableHelper::containerWeight).max().orElse(0);
        }
        if (container instanceof class_93) {
            return ((class_93)container).field_982.stream().mapToInt(LootTableHelper::containerWeight).sum();
        }
        if (container instanceof class_72) {
            return ((class_72)container).field_982.stream().mapToInt(LootTableHelper::containerWeight).sum();
        }
        return 1;
    }

    private static Stream<LootEntry> itemsFromContainer(class_79 container, int totalWeight, Function<class_2960, class_52> lookup) {
        List<LootEntryConditions> conditions = container.field_988.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
        if (container instanceof class_65) {
            class_5250 not = TextComponents.translation((String)"oregrowth.jei_category.conditions.none_of").get();
            LinkedHashSet previousConditions = new LinkedHashSet();
            ArrayList entries = new ArrayList();
            for (class_79 child : ((class_65)container).field_982) {
                Stream<LootEntry> stream = LootTableHelper.itemsFromContainer(child, totalWeight, lookup);
                if (!previousConditions.isEmpty()) {
                    stream = stream.map(entry -> entry.prependConditions(Stream.concat(conditions.stream(), Stream.of(new LootEntryConditions(not, new ArrayList<LootEntryConditions>(previousConditions)))), conditions.size() + 1));
                }
                stream.forEach(entries::add);
                child.field_988.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).forEach(previousConditions::add);
            }
            return entries.stream();
        }
        if (container instanceof class_93) {
            return ((class_93)container).field_982.stream().flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> entry.prependConditions(conditions.stream(), conditions.size()));
        }
        if (container instanceof class_72) {
            LinkedHashSet previousConditions = new LinkedHashSet();
            return ((class_72)container).field_982.stream().flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> {
                LootEntry newEntry = entry.prependConditions(Stream.concat(conditions.stream(), previousConditions.stream()), conditions.size() + previousConditions.size());
                previousConditions.addAll(entry.conditions);
                return newEntry;
            });
        }
        if (container instanceof class_77) {
            return Stream.of(new LootEntry(new class_1799(((class_77)container).field_987), (double)((class_77)container).field_995 / (double)totalWeight, conditions));
        }
        if (container instanceof class_83) {
            return LootTableHelper.entriesInTable((class_52)((class_83)container).field_49429.map(key -> (class_52)lookup.apply(key.method_29177()), Function.identity()), lookup).stream().map(entry -> entry.withChance(entry.chance * (double)((class_83)container).field_995 / (double)totalWeight).prependConditions(conditions.stream(), conditions.size()));
        }
        return Stream.empty();
    }

    private static LootEntryConditions formatCondition(class_5341 condition) {
        if (condition instanceof class_8548) {
            List<LootEntryConditions> subs = ((class_8548)condition).field_1246.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return null;
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.all_of").get(), subs);
        }
        if (condition instanceof class_8551) {
            List<LootEntryConditions> subs = ((class_8551)condition).field_1246.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.never").get(), List.of());
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.any_of").get(), subs);
        }
        if (condition instanceof class_207) {
            LootEntryConditions sub = LootTableHelper.formatCondition(((class_207)condition).comp_1873);
            if (sub == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.not").get(), List.of(sub));
        }
        if (condition instanceof class_227) {
            if (((class_227)condition).comp_1889.isPresent()) {
                if (((Boolean)((class_227)condition).comp_1889.get()).booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining.not").get(), List.of());
            }
            if (((class_227)condition).comp_1890.isPresent()) {
                if (((Boolean)((class_227)condition).comp_1890.get()).booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering.not").get(), List.of());
            }
            return null;
        }
        if (condition instanceof class_223) {
            if (((class_223)condition).comp_1884.isEmpty()) {
                return null;
            }
            class_5250 predicate = LootTableHelper.formatItemPredicate((class_2073)((class_223)condition).comp_1884.get());
            if (predicate == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool").append(predicate).get(), List.of());
        }
        return null;
    }

    private static class_5250 formatItemPredicate(class_2073 predicate) {
        class_5250 enchantments = null;
        List<class_1887> actualEnchants = Stream.concat(predicate.comp_2374().comp_3833().method_57870().method_57845(class_9334.field_49633).map(c -> c.method_57534().stream()).orElseGet(() -> Stream.of(new class_6880[0])).filter(class_6880::method_40227).map(class_6880::comp_349), predicate.comp_2374().comp_3834().values().stream().filter(class_9356.class_9357.class::isInstance).map(class_9356.class_9357.class::cast).flatMap(p -> p.field_49799.stream()).map(class_2035::comp_2665).filter(Optional::isPresent).map(Optional::get).flatMap(class_6885::method_40239).filter(class_6880::method_40227).map(class_6880::comp_349)).distinct().toList();
        if (actualEnchants.size() == 1) {
            enchantments = TextComponents.fromTextComponent((class_2561)actualEnchants.get(0).comp_2686()).color(class_124.field_1065).get();
        } else if (actualEnchants.size() == 2) {
            class_5250 enchant1 = TextComponents.fromTextComponent((class_2561)actualEnchants.get(0).comp_2686()).color(class_124.field_1065).get();
            class_5250 enchant2 = TextComponents.fromTextComponent((class_2561)actualEnchants.get(1).comp_2686()).color(class_124.field_1065).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{enchant1, enchant2}).get();
        } else if (actualEnchants.size() > 2) {
            TextComponents.TextComponentBuilder builder = TextComponents.fromTextComponent((class_2561)actualEnchants.get(0).comp_2686()).color(class_124.field_1065);
            for (int i = 1; i < actualEnchants.size() - 1; ++i) {
                builder = builder.string(", ").append(TextComponents.fromTextComponent((class_2561)actualEnchants.get(i).comp_2686()).color(class_124.field_1065).get());
            }
            class_5250 lastEnchant = TextComponents.fromTextComponent((class_2561)actualEnchants.get(actualEnchants.size() - 1).comp_2686()).color(class_124.field_1065).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), lastEnchant}).get();
        }
        if (predicate.comp_1784.isPresent() && predicate.comp_1784.get() instanceof class_6885.class_6888) {
            class_2960 tag = ((class_6885.class_6888)predicate.comp_1784.get()).method_40251().comp_327();
            if (enchantments == null) {
                return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{tag}).get();
            }
            return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{tag}).translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments}).get();
        }
        if (predicate.comp_1784.isPresent()) {
            TextComponents.TextComponentBuilder itemsFormatted;
            if (((class_6885)predicate.comp_1784.get()).method_40247() == 0) {
                return null;
            }
            List<TextComponents.TextComponentBuilder> items = ((class_6885)predicate.comp_1784.get()).method_40239().map(class_6880::comp_349).map(TextComponents::item).map(b -> b.color(class_124.field_1065)).sorted(Comparator.comparing(TextComponents.TextComponentBuilder::format)).toList();
            if (((class_6885)predicate.comp_1784.get()).method_40247() == 1) {
                itemsFormatted = items.get(0);
            } else if (((class_6885)predicate.comp_1784.get()).method_40247() == 2) {
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{items.get(0), items.get(1)});
            } else if (((class_6885)predicate.comp_1784.get()).method_40247() > 2) {
                TextComponents.TextComponentBuilder builder = items.get(0);
                for (int i = 1; i < ((class_6885)predicate.comp_1784.get()).method_40247() - 1; ++i) {
                    builder = builder.string(", ").append(items.get(i).get());
                }
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), items.get(items.size() - 1)});
            } else {
                throw new AssertionError();
            }
            if (enchantments != null) {
                itemsFormatted = itemsFormatted.translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments});
            }
            return itemsFormatted.get();
        }
        return enchantments;
    }

    private static float averageValue(class_5658 provider) {
        if (provider instanceof class_40) {
            return LootTableHelper.averageValue(((class_40)provider).comp_1893) * LootTableHelper.averageValue(((class_40)provider).comp_1894);
        }
        if (provider instanceof class_44) {
            return ((class_44)provider).comp_1895;
        }
        if (provider instanceof class_5662) {
            return (LootTableHelper.averageValue(((class_5662)provider).comp_1900) + LootTableHelper.averageValue(((class_5662)provider).comp_1901)) / 2.0f;
        }
        return -1.0f;
    }

    public record LootEntry(class_1799 stack, double chance, Collection<LootEntryConditions> conditions) {
        LootEntry withChance(double chance) {
            return new LootEntry(this.stack, chance, this.conditions);
        }

        LootEntry prependConditions(Stream<LootEntryConditions> conditions, int count) {
            LinkedHashSet<LootEntryConditions> merged = new LinkedHashSet<LootEntryConditions>(this.conditions.size() + count);
            conditions.forEach(merged::add);
            merged.addAll(this.conditions);
            return new LootEntry(this.stack, this.chance, merged);
        }
    }

    public record LootEntryConditions(class_5250 component, List<LootEntryConditions> subConditions) {
        public List<class_5250> toComponents() {
            if (this.subConditions.isEmpty()) {
                return List.of(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            }
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            components.add(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            this.subConditions.stream().map(LootEntryConditions::toComponents).flatMap(Collection::stream).map(component -> TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet.spacing").append(component).get()).forEach(components::add);
            return components;
        }
    }
}

