/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat.jei;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.jei.OreGrowthJEIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_778;
import net.minecraft.class_7923;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class OreGrowthJEIRecipeCategory
implements IRecipeCategory<OreGrowthRecipe> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable slotBackground;
    private final IDrawable icon;
    private final IIngredientManager ingredientManager;

    public OreGrowthJEIRecipeCategory(IGuiHelper guiHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createDrawable(class_2960.method_60655((String)"oregrowth", (String)"textures/screen/jei_category_background.png"), 0, 8, 111, 56);
        this.arrow = guiHelper.createDrawable(class_2960.method_60655((String)"oregrowth", (String)"textures/screen/jei_category_background.png"), 111, 0, 32, 15);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)OreGrowth.ORE_GROWTH_BLOCK));
        this.ingredientManager = ingredientManager;
    }

    public RecipeType<OreGrowthRecipe> getRecipeType() {
        return OreGrowthJEIPlugin.ORE_GROWTH_RECIPE_TYPE;
    }

    public class_2561 getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, OreGrowthRecipe recipe, IFocusGroup focusGroup) {
        layoutBuilder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(OreGrowth.ORE_GROWTH_ITEM.method_7854());
        int outputs = Math.min(recipe.getRecipeViewerDrops().size(), 6);
        int columns = outputs > 1 ? 2 : 1;
        int rows = (outputs + 1) / 2;
        for (int i = 0; i < outputs; ++i) {
            OreGrowthRecipe.RecipeViewerDrop drop = recipe.getRecipeViewerDrops().get(i);
            int x = 93 - columns * 9 + i % columns * 18;
            int y = 29 - rows * 9 + i / columns * 18;
            ArrayList<Object> tooltips = new ArrayList<Object>(3);
            tooltips.add(TextComponents.empty().get());
            class_5250 minGrowth = TextComponents.number((int)((int)Math.round((double)drop.minStage() / (double)recipe.stages() * 100.0))).color(class_124.field_1065).string("%").color(class_124.field_1065).get();
            class_5250 maxGrowth = TextComponents.number((int)((int)Math.round((double)drop.maxStage() / (double)recipe.stages() * 100.0))).color(class_124.field_1065).string("%").color(class_124.field_1065).get();
            if (drop.maxStage() > 1 || drop.maxStage() < recipe.stages()) {
                if (drop.minStage() == drop.maxStage()) {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth", (Object[])new Object[]{minGrowth}).get());
                } else {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth.range", (Object[])new Object[]{minGrowth, maxGrowth}).get());
                }
            }
            if (drop.chance() < 1.0) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.chance", (Object[])new Object[]{TextComponents.number((double)(drop.chance() * 100.0)).color(class_124.field_1065).string("%").color(class_124.field_1065).get()}).get());
            }
            if (!drop.tooltip().isEmpty()) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.conditions").get());
                tooltips.addAll(drop.tooltip());
            }
            layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground(this.slotBackground, -1, -1).addRichTooltipCallback((slotView, list) -> list.addAll((Collection)tooltips)).addItemStack(drop.result());
        }
        final IIngredientRenderer originalRenderer = this.ingredientManager.getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK);
        ((IRecipeSlotBuilder)layoutBuilder.addSlot(RecipeIngredientRole.CATALYST, columns == 1 ? 11 : 2, 24).setSlotName("base").addItemStacks(recipe.bases((class_7225.class_7226<class_2248>)class_7923.field_41175).stream().map(class_2248::method_8389).map(class_1792::method_7854).toList())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<class_1799>(this){

            public void render(class_332 guiGraphics, class_1799 stack) {
            }

            public void getTooltip(ITooltipBuilder tooltip, class_1799 ingredient, class_1836 tooltipFlag) {
                originalRenderer.getTooltip(tooltip, (Object)ingredient, tooltipFlag);
            }

            public List<class_2561> getTooltip(class_1799 stack, class_1836 flag) {
                return List.of();
            }

            public class_327 getFontRenderer(class_310 minecraft, class_1799 ingredient) {
                return originalRenderer.getFontRenderer(minecraft, (Object)ingredient);
            }

            public int getWidth() {
                return 30;
            }

            public int getHeight() {
                return 30;
            }
        });
    }

    public void draw(OreGrowthRecipe recipe, IRecipeSlotsView slotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        guiGraphics.method_51448().popMatrix();
        if (slotsView.getSlotViews(RecipeIngredientRole.OUTPUT).size() <= 1) {
            guiGraphics.method_51448().translate(9.0f, 0.0f);
        }
        this.arrow.draw(guiGraphics, 37, 20);
        guiGraphics.method_51445(class_1802.field_8377.method_7854(), 43, 18);
        class_2248 base = slotsView.findSlotByName("base").flatMap(IRecipeSlotView::getDisplayedItemStack).map(class_1799::method_7909).filter(class_1747.class::isInstance).map(item -> ((class_1747)item).method_7711()).orElse(null);
        if (base != null) {
            GuiGraphicsHelper.of((class_332)guiGraphics).submitCustomRendering(22, 39, 40, 40, poseStack -> OreGrowthJEIRecipeCategory.renderModel(poseStack, base.method_9564(), 22, 39, 0));
        }
        if (base != null) {
            int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
            class_2680 state = (class_2680)OreGrowth.ORE_GROWTH_BLOCK.method_9564().method_11657((class_2769)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
            class_1087 model = ClientUtils.getBlockRenderer().method_3349(state);
            if (model instanceof OreGrowthBlockBakedModel) {
                GuiGraphicsHelper.of((class_332)guiGraphics).submitCustomRendering(22, 39, 40, 40, poseStack -> ((OreGrowthBlockBakedModel)model).withContext(base, () -> OreGrowthJEIRecipeCategory.renderModel(poseStack, state, 22, 23, 10)));
            } else {
                GuiGraphicsHelper.of((class_332)guiGraphics).submitCustomRendering(22, 39, 40, 40, poseStack -> OreGrowthJEIRecipeCategory.renderModel(poseStack, state, 22, 23, 10));
            }
        }
        guiGraphics.method_51448().popMatrix();
    }

    private static void renderModel(class_4587 poseStack, class_2680 state, int x, int y, int offset) {
        poseStack.method_46416((float)(x + 21), (float)(y + 16), (float)(150 + offset));
        poseStack.method_22905(1.85f, 1.85f, 1.85f);
        poseStack.method_22905(16.0f, -16.0f, 16.0f);
        class_1087 model = ClientUtils.getBlockRenderer().method_3349(state);
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f));
        poseStack.method_22905(0.625f, 0.625f, 0.625f);
        class_778.method_3367((class_4587.class_4665)poseStack.method_23760(), (class_4588)RenderUtils.getMainBufferSource().getBuffer(class_4722.method_29382()), (class_1087)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)class_4608.field_21444);
    }
}

