/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.OreGrowthConfig;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlock
extends BaseBlock
implements class_3737 {
    public static final int MAX_STAGES = 4;
    public static class_2758 STAGE = class_2758.method_11867((String)"stage", (int)1, (int)4);
    public static class_2754<class_2350> FACE = class_2741.field_12525;
    public static class_2746 WATERLOGGED = class_2741.field_12508;
    private static final BlockShape[] SHAPES = new BlockShape[]{BlockShape.createBlockShape((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), BlockShape.createBlockShape((double)5.8, (double)0.0, (double)5.8, (double)10.2, (double)7.0, (double)10.2), BlockShape.createBlockShape((double)5.2, (double)0.0, (double)5.2, (double)10.8, (double)9.0, (double)10.8), BlockShape.createBlockShape((double)5.1, (double)0.0, (double)5.1, (double)10.9, (double)11.0, (double)10.9)};
    private static final BlockShape[] SHAPES_ROTATED = new BlockShape[SHAPES.length * 6];

    public static void trySpawnOreGrowth(OreGrowthRecipe recipe, class_3218 level, class_2338 pos, class_5819 random) {
        if ((double)random.method_43057() > recipe.spawnChance() * OreGrowthConfig.spawnChanceScalar.get()) {
            return;
        }
        class_2350 side = class_2350.values()[random.method_43048(class_2350.values().length)];
        class_2338 growthPos = pos.method_10093(side);
        class_2680 currentState = level.method_8320(growthPos);
        if (!currentState.method_26215() && !currentState.method_27852(class_2246.field_10382)) {
            return;
        }
        level.method_8501(growthPos, (class_2680)((class_2680)OreGrowth.ORE_GROWTH_BLOCK.method_9564().method_11657(FACE, (Comparable)side.method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(currentState.method_26227().method_15772() == class_3612.field_15910)));
    }

    public OreGrowthBlock() {
        super(false, BlockProperties.create().noLootTable().randomTicks().destroyTime(0.5f).explosionResistance(0.5f).sound(class_2498.field_11544));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(1))).method_11657(FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2248 base = level.method_8320(pos.method_10093((class_2350)state.method_11654(FACE))).method_26204();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.field_9236).getRecipeFor(base);
        if (recipe == null) {
            level.method_8501(pos, class_2246.field_10124.method_9564());
            return;
        }
        int stage = (Integer)state.method_11654((class_2769)STAGE);
        if (stage < recipe.stages() && (double)random.method_43057() < recipe.growthChance() * OreGrowthConfig.growthChanceScalar.get()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(stage + 1)));
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_3218 level = builder.method_51870();
        if (level == null) {
            return Collections.emptyList();
        }
        class_243 origin = (class_243)builder.method_51873(class_181.field_24424);
        class_2338 pos = new class_2338((int)Math.floor(origin.field_1352), (int)Math.floor(origin.field_1351), (int)Math.floor(origin.field_1350));
        class_2350 facing = (class_2350)state.method_11654(FACE);
        class_2680 base = level.method_8320(pos.method_10093(facing));
        class_1297 entity = (class_1297)builder.method_51876(class_181.field_1226);
        if (entity instanceof class_1657 ? !((class_1657)entity).method_7305(base) : (entity instanceof class_1309 ? !((class_1309)entity).method_6047().method_7951(base) : base.method_29291())) {
            return Collections.emptyList();
        }
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.field_9236).getRecipeFor(base.method_26204());
        if (recipe == null) {
            return Collections.emptyList();
        }
        class_8567 lootParams = builder.method_51874(class_181.field_1224, (Object)state).method_51875(class_173.field_1172);
        return recipe.generateDrops(state, (Integer)state.method_11654((class_2769)STAGE), lootParams);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        pos = pos.method_10093((class_2350)state.method_11654(FACE));
        return level.method_8320(pos).method_26165(player, level, pos);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2248 base = level.method_8320(pos.method_10093((class_2350)state.method_11654(FACE))).method_26204();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.field_9236).getRecipeFor(base);
        if (recipe == null) {
            return 0;
        }
        int stage = (Integer)state.method_11654((class_2769)STAGE);
        return (int)Math.floor((double)stage / (double)recipe.stages() * 15.0);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPES_ROTATED[((Integer)state.method_11654((class_2769)STAGE) - 1) * 6 + ((class_2350)state.method_11654(FACE)).ordinal()].getUnderlying();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STAGE, FACE, WATERLOGGED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(FACE, (Comparable)context.method_8038().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910));
        return this.method_9558(state, (class_4538)context.method_8045(), context.method_8037()) ? state : null;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!this.method_9558(state, level, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return super.method_9559(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654(FACE);
        return OreGrowthRecipeManager.get(level.method_8608()).getRecipeFor(level.method_8320(pos.method_10093(facing)).method_26204()) != null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    static {
        for (int stage = 0; stage < 4; ++stage) {
            BlockShape shape = SHAPES[stage];
            for (class_2350 face : class_2350.values()) {
                OreGrowthBlock.SHAPES_ROTATED[stage * 6 + face.ordinal()] = face == class_2350.field_11036 ? shape.rotate(class_2350.class_2351.field_11048).rotate(class_2350.class_2351.field_11048) : (face == class_2350.field_11043 ? shape.rotate(class_2350.class_2351.field_11048).rotate(class_2350.class_2351.field_11052).rotate(class_2350.class_2351.field_11052) : (face == class_2350.field_11034 ? shape.rotate(class_2350.class_2351.field_11048).rotate(class_2350.class_2351.field_11052).rotate(class_2350.class_2351.field_11052).rotate(class_2350.class_2351.field_11052) : (face == class_2350.field_11035 ? shape.rotate(class_2350.class_2351.field_11048) : (face == class_2350.field_11039 ? shape.rotate(class_2350.class_2351.field_11048).rotate(class_2350.class_2351.field_11052) : shape))));
            }
        }
    }
}

