/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.EmptyLevelView;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlockBakedModel
implements class_1087 {
    private static final class_2350[] MODEL_DIRECTIONS = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, null};
    private final class_1087 original;
    private final Mesh mesh;
    private final class_1058[] meshSprites;
    private final Map<class_2248, MaterialEntry> blockMaterialCache = new HashMap<class_2248, MaterialEntry>();
    private final Map<class_2248, MaterialEntry> itemMaterialCache = new HashMap<class_2248, MaterialEntry>();
    private class_2248 baseBlockContext;

    public OreGrowthBlockBakedModel(class_1087 original) {
        this.original = original;
        Renderer renderer = Renderer.get();
        MutableMesh mesh = renderer.mutableMesh();
        QuadEmitter emitter = mesh.emitter();
        class_5819 random = class_5819.method_43047();
        ArrayList<class_1058> sprites = new ArrayList<class_1058>();
        for (class_10889 part : original.method_68512(random)) {
            for (class_2350 cullFace : MODEL_DIRECTIONS) {
                List quads = part.method_68509(cullFace);
                for (class_777 quad : quads) {
                    emitter.fromBakedQuad(quad);
                    emitter.cullFace(cullFace);
                    int spriteIndex = sprites.indexOf(quad.comp_3724());
                    if (spriteIndex == -1) {
                        spriteIndex = sprites.size();
                        sprites.add(quad.comp_3724());
                    }
                    emitter.tag(spriteIndex);
                    emitter.emit();
                }
            }
        }
        this.mesh = mesh.immutableCopy();
        this.meshSprites = (class_1058[])sprites.toArray(class_1058[]::new);
    }

    public void withContext(class_2248 baseBlock, Runnable runnable) {
        this.baseBlockContext = baseBlock;
        runnable.run();
        this.baseBlockContext = null;
    }

    private class_2248 getBase(class_1920 blockView, class_2338 pos, class_2680 state) {
        class_2248 base;
        if (this.baseBlockContext == null) {
            if (!state.method_27852((class_2248)OreGrowth.ORE_GROWTH_BLOCK)) {
                return null;
            }
            class_2338 basePos = pos.method_10093((class_2350)state.method_11654(OreGrowthBlock.FACE));
            base = blockView.method_8320(basePos).method_26204();
        } else {
            base = this.baseBlockContext;
        }
        return base;
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        class_2248 base = this.getBase(blockView, pos, state);
        this.emitQuads(base, this.blockMaterialCache, (model, output) -> {
            class_2680 baseState = base.method_9564();
            class_2338 basePos = state.method_27852((class_2248)OreGrowth.ORE_GROWTH_BLOCK) ? pos.method_10093((class_2350)state.method_11654(OreGrowthBlock.FACE)) : pos;
            model.emitQuads(output, blockView, basePos, baseState, random, side -> false);
        }, emitter);
    }

    public void emitItemQuads(class_10444.class_10446 renderLayer, class_5819 random) {
        class_2248 base = this.baseBlockContext;
        if (base == null) {
            this.mesh.outputTo(renderLayer.emitter());
            return;
        }
        this.emitQuads(base, this.itemMaterialCache, (model, output) -> {
            random.method_43052(42L);
            model.emitQuads(output, (class_1920)EmptyLevelView.INSTANCE, class_2338.field_10980, base.method_9564(), random, direction -> false);
        }, renderLayer.emitter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitQuads(class_2248 base, Map<class_2248, MaterialEntry> materialCache, BiConsumer<class_1087, QuadEmitter> modelEmitter, QuadEmitter emitter) {
        MaterialEntry material;
        Map<class_2248, MaterialEntry> map = materialCache;
        synchronized (map) {
            material = materialCache.get(base);
        }
        if (material == null) {
            material = OreGrowthBlockBakedModel.findMaterial(base, modelEmitter);
            map = materialCache;
            synchronized (map) {
                if (!materialCache.containsKey(base)) {
                    materialCache.put(base, material);
                } else {
                    material = materialCache.get(base);
                }
            }
        }
        if (material == null) {
            this.mesh.outputTo(emitter);
            return;
        }
        class_1058 newSprite = material.sprite;
        boolean shading = material.shading;
        boolean emissive = material.emissive;
        TriState ambientOcclusion = material.ambientOcclusion;
        emitter.pushTransform(quad -> {
            class_1058 originalSprite = this.meshSprites[quad.tag()];
            for (int i = 0; i < 4; ++i) {
                quad.uv(i, newSprite.method_4594() + (quad.u(i) - originalSprite.method_4594()) / (originalSprite.method_4577() - originalSprite.method_4594()) * (newSprite.method_4577() - newSprite.method_4594()), newSprite.method_4593() + (quad.v(i) - originalSprite.method_4593()) / (originalSprite.method_4575() - originalSprite.method_4593()) * (newSprite.method_4575() - newSprite.method_4593()));
                quad.diffuseShade(shading);
                quad.emissive(emissive);
                quad.ambientOcclusion(ambientOcclusion);
            }
            return true;
        });
        this.mesh.outputTo(emitter);
        emitter.popTransform();
    }

    private static MaterialEntry findMaterial(class_2248 baseBlock, BiConsumer<class_1087, QuadEmitter> modelEmitter) {
        class_2680 baseState = baseBlock.method_9564();
        class_1087 baseModel = ClientUtils.getBlockRenderer().method_3349(baseState);
        HashMap materials = new HashMap();
        MutableMesh dummyMesh = Renderer.get().mutableMesh();
        QuadEmitter emitter = dummyMesh.emitter();
        SpriteFinder spriteFinder = SpriteFinder.get((class_1059)ClientUtils.getMinecraft().method_1554().method_24153(TextureAtlases.getBlocks()));
        emitter.pushTransform(quad -> {
            class_1058 sprite = spriteFinder.find((QuadView)quad);
            if (sprite != null) {
                materials.compute(sprite, (s, pair) -> pair == null ? Pair.of((Object)1, (Object)new MaterialEntry((class_1058)s, quad.diffuseShade(), quad.emissive(), quad.ambientOcclusion())) : pair.mapLeft(i -> i + 1));
            }
            return false;
        });
        modelEmitter.accept(baseModel, emitter);
        emitter.popTransform();
        if (materials.isEmpty()) {
            return null;
        }
        MaterialEntry material = null;
        int count = 0;
        for (Map.Entry entry : materials.entrySet()) {
            if ((Integer)((Pair)entry.getValue()).left() <= count) continue;
            material = (MaterialEntry)((Pair)entry.getValue()).right();
            count = (Integer)((Pair)entry.getValue()).left();
        }
        return material;
    }

    @Nullable
    public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
        return Pair.of((Object)this, (Object)this.getBase(blockView, pos, state));
    }

    public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
        class_2248 base = this.getBase(blockView, pos, state);
        class_2680 baseState = base.method_9564();
        if (baseState.method_26215()) {
            return this.original.particleSprite(blockView, pos, state);
        }
        class_1087 baseModel = ClientUtils.getBlockRenderer().method_3349(baseState);
        return baseModel.particleSprite(blockView, pos, state);
    }

    public void method_68513(class_5819 randomSource, List<class_10889> list) {
        this.original.method_68513(randomSource, list);
    }

    public class_1058 method_68511() {
        return this.original.method_68511();
    }

    private record MaterialEntry(class_1058 sprite, boolean shading, boolean emissive, TriState ambientOcclusion) {
    }
}

