/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.codec.CodecHelper;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Either;
import com.supermartijn642.oregrowth.LootTableHelper;
import com.supermartijn642.oregrowth.OreGrowth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public class OreGrowthRecipe
implements class_1860<class_9695> {
    public static final class_1865<OreGrowthRecipe> SERIALIZER = new Serializer();
    private final List<Either<class_2248, class_6862<class_2248>>> bases;
    private List<class_2248> resolvedBases;
    private final int stages;
    private final double spawnChance;
    private final double growthChance;
    private final List<OreGrowthDrop> drops;
    private List<RecipeViewerDrop> resolvedDrops;

    private OreGrowthRecipe(List<Either<class_2248, class_6862<class_2248>>> bases, int stages, double spawnChance, double growthChance, List<OreGrowthDrop> drops) {
        this.bases = Collections.unmodifiableList(bases);
        this.stages = stages;
        this.spawnChance = spawnChance;
        this.growthChance = growthChance;
        this.drops = Collections.unmodifiableList(drops);
    }

    public List<class_2248> bases(class_7225.class_7226<class_2248> blockLookup) {
        if (this.resolvedBases == null) {
            this.resolvedBases = this.bases.stream().flatMap(base -> base.isLeft() ? Stream.of((class_2248)base.left()) : blockLookup.method_46733((class_6862)base.right()).map(tag -> tag.method_40239().map(class_6880::comp_349)).orElseGet(() -> Stream.of(new class_2248[0]))).toList();
        }
        return this.resolvedBases;
    }

    public int stages() {
        return this.stages;
    }

    public double spawnChance() {
        return this.spawnChance;
    }

    public double growthChance() {
        return this.growthChance;
    }

    public List<class_1799> generateDrops(class_2680 base, int stage, class_8567 context) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        for (OreGrowthDrop drop : this.drops) {
            if (drop.minStage > stage || drop.maxStage < stage || drop.chance < 1.0 && context.method_51863().method_8409().method_43058() > drop.chance) continue;
            if (drop.result.isLeft()) {
                drops.add(((class_1799)drop.result.left()).method_7972());
                continue;
            }
            context.method_51863().method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)((class_2960)drop.result.right()))).method_51882(context, drops::add);
        }
        return drops;
    }

    public List<RecipeViewerDrop> getRecipeViewerDrops() {
        if (this.resolvedDrops == null) {
            if (!CommonUtils.getEnvironmentSide().isClient() && ClientUtils.getMinecraft().method_1576() == null) {
                throw new IllegalStateException("Drops should have already been resolved when received from the server!");
            }
            this.resolveDrops(identifier -> CommonUtils.getServer().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)identifier)));
        }
        return this.resolvedDrops;
    }

    public void resolveDrops(Function<class_2960, class_52> lookup) {
        if (this.resolvedDrops == null) {
            this.resolvedDrops = this.drops.stream().flatMap(drop -> (Stream)drop.result.flatMap(stack -> Stream.of(new RecipeViewerDrop(drop.minStage, drop.maxStage, drop.chance, (class_1799)stack, List.of())), loot -> LootTableHelper.entriesInTable(loot, lookup).stream().map(entry -> new RecipeViewerDrop(drop.minStage, drop.maxStage, drop.chance * entry.chance(), entry.stack(), entry.conditions().stream().map(LootTableHelper.LootEntryConditions::toComponents).flatMap(Collection::stream).toList())))).sorted(Comparator.comparing(RecipeViewerDrop::maxStage, Comparator.reverseOrder()).thenComparing(RecipeViewerDrop::minStage, Comparator.reverseOrder()).thenComparing(RecipeViewerDrop::chance, Comparator.reverseOrder())).toList();
        }
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_8115(class_9695 input, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_9695 input, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    public class_1865<OreGrowthRecipe> method_8119() {
        return SERIALIZER;
    }

    public class_3956<OreGrowthRecipe> method_17716() {
        return OreGrowth.ORE_GROWTH_RECIPE_TYPE;
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public class_10355 method_64668() {
        return class_314.field_1810;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "oregrowth:ore_growth");
        if (this.bases.size() == 1) {
            json.addProperty("base", (String)this.bases.get(0).flatMap(block -> Registries.BLOCKS.getIdentifier(block).toString(), tag -> "#" + String.valueOf(tag.comp_327())));
        } else {
            JsonArray bases = new JsonArray(this.bases.size());
            this.bases.stream().map(base -> (String)base.flatMap(block -> Registries.BLOCKS.getIdentifier(block).toString(), tag -> "#" + String.valueOf(tag.comp_327()))).forEach(arg_0 -> ((JsonArray)bases).add(arg_0));
            json.add("base", (JsonElement)bases);
        }
        json.addProperty("stages", (Number)this.stages);
        json.addProperty("spawn_chance", (Number)this.spawnChance);
        json.addProperty("growth_chance", (Number)this.growthChance);
        JsonArray dropsArray = new JsonArray(this.drops.size());
        this.drops.forEach(drop -> dropsArray.add((JsonElement)drop.toJson()));
        json.add("drops", (JsonElement)dropsArray);
        return json;
    }

    public static OreGrowthRecipe fromJson(JsonObject json) {
        JsonArray basesJson;
        if (!(json.has("base") && (json.get("base").isJsonPrimitive() && json.getAsJsonPrimitive("base").isString() || json.get("base").isJsonArray()))) {
            throw new JsonParseException("Recipe must have array property 'base'!");
        }
        if (json.get("base").isJsonPrimitive()) {
            basesJson = new JsonArray(1);
            basesJson.add(json.get("base").getAsString());
        } else {
            basesJson = json.getAsJsonArray("base");
        }
        HashSet<Either> bases = new HashSet<Either>(basesJson.size());
        for (JsonElement baseJson : basesJson) {
            if (!baseJson.isJsonPrimitive() || !baseJson.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'base' must only contain strings!");
            }
            String baseIdentifier = baseJson.getAsString();
            if (baseIdentifier.charAt(0) == '#') {
                if (!RegistryUtil.isValidIdentifier((String)(baseIdentifier = baseIdentifier.substring(1)))) {
                    throw new JsonParseException("Property 'base' must be a valid identifier, not '" + baseIdentifier + "'!");
                }
                bases.add(Either.right((Object)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)baseIdentifier))));
                continue;
            }
            if (!RegistryUtil.isValidIdentifier((String)baseIdentifier)) {
                throw new JsonParseException("Property 'base' must be a valid identifier, not '" + baseIdentifier + "'!");
            }
            if (!Registries.BLOCKS.hasIdentifier(class_2960.method_60654((String)baseIdentifier))) {
                throw new JsonParseException("Unknown base block '" + baseIdentifier + "'!");
            }
            class_2248 block = (class_2248)Registries.BLOCKS.getValue(class_2960.method_60654((String)baseIdentifier));
            if (block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243) {
                throw new JsonParseException("Got AIR block for base identifier '" + baseIdentifier + "'!");
            }
            bases.add(Either.left((Object)block));
        }
        if (!(json.has("stages") && json.get("stages").isJsonPrimitive() && json.getAsJsonPrimitive("stages").isNumber())) {
            throw new JsonParseException("Recipe must have int property 'stages'!");
        }
        int stages = json.get("stages").getAsInt();
        if (stages < 1 || stages > 4) {
            throw new JsonParseException("Invalid number of stages: '" + stages + "'!");
        }
        if (!(json.has("spawn_chance") && json.get("spawn_chance").isJsonPrimitive() && json.getAsJsonPrimitive("spawn_chance").isNumber())) {
            throw new JsonParseException("Recipe must have number property 'spawn_chance'!");
        }
        double spawnChance = json.get("spawn_chance").getAsDouble();
        if (spawnChance <= 0.0 || spawnChance > 1.0) {
            throw new JsonParseException("Invalid spawn chance: '" + spawnChance + "'!");
        }
        if (!(json.has("growth_chance") && json.get("growth_chance").isJsonPrimitive() && json.getAsJsonPrimitive("growth_chance").isNumber())) {
            throw new JsonParseException("Recipe must have number property 'growth_chance'!");
        }
        double growthChance = json.get("growth_chance").getAsDouble();
        if (growthChance <= 0.0 || growthChance > 1.0) {
            throw new JsonParseException("Invalid growth chance: '" + growthChance + "'!");
        }
        ArrayList<OreGrowthDrop> drops = new ArrayList<OreGrowthDrop>();
        if (json.has("result")) {
            if (!json.get("result").isJsonObject()) {
                throw new JsonParseException("Property 'result' must be an object!");
            }
            JsonObject resultJson = json.getAsJsonObject("result");
            if (!((resultJson.has("item") && resultJson.get("item").isJsonPrimitive() && resultJson.getAsJsonPrimitive("item").isString() || resultJson.has("id") && resultJson.get("id").isJsonPrimitive() && resultJson.getAsJsonPrimitive("id").isString()) && resultJson.has("count") && resultJson.get("count").isJsonPrimitive() && resultJson.getAsJsonPrimitive("count").isNumber())) {
                throw new JsonParseException("Property 'result' must have string property 'item' and int property 'count'!");
            }
            if (resultJson.has("item") && resultJson.has("id")) {
                throw new JsonParseException("Property 'result' can only have either string property 'item' or string property 'id', not both!");
            }
            if (resultJson.has("item") && !RegistryUtil.isValidIdentifier((String)resultJson.get("item").getAsString())) {
                throw new JsonParseException("Drop property 'item' must be a valid identifier, not '" + resultJson.get("item").getAsString() + "'!");
            }
            if (resultJson.has("id") && !RegistryUtil.isValidIdentifier((String)resultJson.get("id").getAsString())) {
                throw new JsonParseException("Drop property 'id' must be a valid identifier, not '" + resultJson.get("id").getAsString() + "'!");
            }
            class_2960 id = class_2960.method_60654((String)(resultJson.has("item") ? resultJson.get("item").getAsString() : resultJson.get("id").getAsString()));
            if (!Registries.ITEMS.hasIdentifier(id)) {
                throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'!");
            }
            class_1792 item = (class_1792)Registries.ITEMS.getValue(id);
            int count = resultJson.get("count").getAsInt();
            if (count < 1) {
                throw new JsonParseException("Drop property 'count' must be a positive integer!");
            }
            drops.add(new OreGrowthDrop(stages, stages, 1.0, (Either<class_1799, class_2960>)Either.left((Object)new class_1799((class_1935)item, count))));
        } else {
            if (!json.has("drops") || !json.get("drops").isJsonArray()) {
                throw new JsonParseException("Recipe must have array property 'drops'!");
            }
            JsonArray dropsArray = json.getAsJsonArray("drops");
            if (dropsArray.size() == 0) {
                throw new JsonParseException("Property 'drops' must have at least one entry!");
            }
            for (JsonElement el : dropsArray) {
                if (!el.isJsonObject()) {
                    throw new JsonParseException("Drop property 'drops' must only contain objects!");
                }
                drops.add(OreGrowthDrop.fromJson(el.getAsJsonObject()));
            }
        }
        return new OreGrowthRecipe(new ArrayList<Either<class_2248, class_6862<class_2248>>>(bases), stages, spawnChance, growthChance, drops);
    }

    public record OreGrowthDrop(int minStage, int maxStage, double chance, Either<class_1799, class_2960> result) {
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.minStage == this.maxStage) {
                json.addProperty("stage", (Number)this.minStage);
            } else {
                json.addProperty("min_stage", (Number)this.minStage);
                json.addProperty("max_stage", (Number)this.maxStage);
            }
            json.addProperty("chance", (Number)this.chance);
            this.result.ifLeft(stack -> {
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier((Object)stack.method_7909()).toString());
                resultJson.addProperty("count", (Number)stack.method_7947());
                json.add("item", (JsonElement)resultJson);
            });
            this.result.ifRight(lootTable -> json.addProperty("loot_table", lootTable.toString()));
            return json;
        }

        public static OreGrowthDrop fromJson(JsonObject json) {
            Either result;
            double chance;
            int minStage;
            int maxStage;
            if (!(json.has("min_stage") && json.has("max_stage") || json.has("stage"))) {
                throw new JsonParseException("Drop must either have int properties 'min_stage' and 'max_stage', or have int property 'stage'!");
            }
            if ((json.has("min_stage") || json.has("max_stage")) && json.has("stage")) {
                throw new JsonParseException("Drop must have int properties 'min_stage' and 'max_stage', or int property 'stage', not both!");
            }
            if (json.has("stage")) {
                if (!json.get("stage").isJsonPrimitive() || !json.getAsJsonPrimitive("stage").isNumber()) {
                    throw new JsonParseException("Drop property 'stage' must be an integer!");
                }
                int stage = json.get("stage").getAsInt();
                if (stage < 1 || stage > 4) {
                    throw new JsonParseException("Drop property 'stage' must be between 1 and 4!");
                }
                minStage = maxStage = stage;
            } else {
                if (!(json.has("min_stage") && json.get("min_stage").isJsonPrimitive() && json.getAsJsonPrimitive("min_stage").isNumber())) {
                    throw new JsonParseException("Drop must have int property 'min_stage'!");
                }
                minStage = json.get("min_stage").getAsInt();
                if (minStage < 1 || minStage > 4) {
                    throw new JsonParseException("Drop property 'min_stage' must be between 1 and 4!");
                }
                if (!(json.has("max_stage") && json.get("max_stage").isJsonPrimitive() && json.getAsJsonPrimitive("max_stage").isNumber())) {
                    throw new JsonParseException("Drop must have int property 'max_stage'!");
                }
                maxStage = json.get("max_stage").getAsInt();
                if (maxStage < 1 || maxStage > 4) {
                    throw new JsonParseException("Drop property 'maxStage' must be between 1 and 4!");
                }
                if (minStage > maxStage) {
                    throw new JsonParseException("Drop property 'min_stage' must be less than 'max_stage'!");
                }
            }
            if (!(!json.has("chance") || json.get("chance").isJsonPrimitive() && json.getAsJsonPrimitive("chance").isNumber())) {
                throw new JsonParseException("Drop property 'chance' must be a number!");
            }
            double d = chance = json.has("chance") ? json.get("chance").getAsDouble() : 1.0;
            if (chance < 0.0 || chance > 1.0) {
                throw new JsonParseException("Drop property 'chance' must be between 0 and 1!");
            }
            if (!json.has("item") && !json.has("loot_table")) {
                throw new JsonParseException("Drop must have either object property 'item' or string property 'loot_table'!");
            }
            if (json.has("item") && json.has("loot_table")) {
                throw new JsonParseException("Drop can only have either 'item' or 'loot_table', not both!");
            }
            if (json.has("item")) {
                if (!json.get("item").isJsonObject()) {
                    throw new JsonParseException("Drop property 'item' must be an object!");
                }
                JsonObject resultJson = json.getAsJsonObject("item");
                if (!(resultJson.has("id") && resultJson.get("id").isJsonPrimitive() && resultJson.getAsJsonPrimitive("id").isString() && resultJson.has("count") && resultJson.get("count").isJsonPrimitive() && resultJson.getAsJsonPrimitive("count").isNumber())) {
                    throw new JsonParseException("Drop property 'item' must have string property 'id' and int property 'count'!");
                }
                if (!RegistryUtil.isValidIdentifier((String)resultJson.get("id").getAsString())) {
                    throw new JsonParseException("Drop property 'id' must be a valid identifier, not '" + resultJson.get("id").getAsString() + "'!");
                }
                class_2960 id = class_2960.method_60654((String)resultJson.get("id").getAsString());
                if (!Registries.ITEMS.hasIdentifier(id)) {
                    throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'!");
                }
                class_1792 item = (class_1792)Registries.ITEMS.getValue(id);
                int count = resultJson.get("count").getAsInt();
                if (count < 1) {
                    throw new JsonParseException("Drop property 'count' must be a positive integer!");
                }
                result = Either.left((Object)new class_1799((class_1935)item, count));
            } else {
                if (!json.get("loot_table").isJsonPrimitive() || !json.getAsJsonPrimitive("loot_table").isString()) {
                    throw new JsonParseException("Drop property 'loot_table' must be a string!");
                }
                if (!RegistryUtil.isValidIdentifier((String)json.get("loot_table").getAsString())) {
                    throw new JsonParseException("Drop property 'loot_table' must be a valid identifier, not '" + json.get("loot_table").getAsString() + "'!");
                }
                result = Either.right((Object)class_2960.method_60654((String)json.get("loot_table").getAsString()));
            }
            return new OreGrowthDrop(minStage, maxStage, chance, (Either<class_1799, class_2960>)result);
        }
    }

    public record RecipeViewerDrop(int minStage, int maxStage, double chance, class_1799 result, List<? extends class_2561> tooltip) {
    }

    private static class Serializer
    implements class_1865<OreGrowthRecipe> {
        private static final MapCodec<OreGrowthRecipe> CODEC = CodecHelper.jsonSerializerToMapCodec(OreGrowthRecipe::toJson, json -> OreGrowthRecipe.fromJson(json.getAsJsonObject()));
        private static final class_9139<class_9129, OreGrowthRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        private Serializer() {
        }

        public MapCodec<OreGrowthRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, OreGrowthRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static OreGrowthRecipe fromNetwork(class_9129 buffer) {
            int baseCount = buffer.readInt();
            ArrayList<Either<class_2248, class_6862<class_2248>>> bases = new ArrayList<Either<class_2248, class_6862<class_2248>>>(baseCount);
            for (int i = 0; i < baseCount; ++i) {
                boolean isBlock = buffer.readBoolean();
                class_2960 baseIdentifier = buffer.method_10810();
                if (isBlock) {
                    if (!Registries.BLOCKS.hasIdentifier(baseIdentifier)) {
                        throw new IllegalArgumentException("Unknown block '" + String.valueOf(baseIdentifier) + "'!");
                    }
                    class_2248 block = (class_2248)Registries.BLOCKS.getValue(baseIdentifier);
                    if (block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243) {
                        throw new IllegalArgumentException("Got AIR block for identifier '" + String.valueOf(baseIdentifier) + "'!");
                    }
                    bases.add(Either.left((Object)block));
                    continue;
                }
                bases.add(Either.right((Object)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)baseIdentifier)));
            }
            int stages = buffer.readInt();
            if (stages < 1 || stages > 4) {
                throw new IllegalArgumentException("Invalid number of stages: '" + stages + "'!");
            }
            double spawnChance = buffer.readDouble();
            if (spawnChance <= 0.0 || spawnChance > 1.0) {
                throw new IllegalArgumentException("Invalid spawn chance: '" + spawnChance + "'!");
            }
            double growthChance = buffer.readDouble();
            if (growthChance <= 0.0 || growthChance > 1.0) {
                throw new IllegalArgumentException("Invalid growth chance: '" + growthChance + "'!");
            }
            int dropCount = buffer.readInt();
            ArrayList<OreGrowthDrop> drops = new ArrayList<OreGrowthDrop>(dropCount);
            for (int i = 0; i < dropCount; ++i) {
                int minStage = buffer.readInt();
                int maxStage = buffer.readInt();
                double chance = buffer.readDouble();
                Either result = buffer.readBoolean() ? Either.left((Object)((class_1799)class_1799.field_49268.decode((Object)buffer))) : Either.right((Object)buffer.method_10810());
                drops.add(new OreGrowthDrop(minStage, maxStage, chance, (Either<class_1799, class_2960>)result));
            }
            int resolvedDropCount = buffer.readInt();
            ArrayList<RecipeViewerDrop> resolvedDrops = new ArrayList<RecipeViewerDrop>(resolvedDropCount);
            for (int i = 0; i < resolvedDropCount; ++i) {
                int minStage = buffer.readInt();
                int maxStage = buffer.readInt();
                double chance = buffer.readDouble();
                class_1799 result = (class_1799)class_1799.field_49268.decode((Object)buffer);
                int tooltipCount = buffer.readInt();
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>(tooltipCount);
                for (int j = 0; j < tooltipCount; ++j) {
                    tooltip.add((class_2561)class_8824.field_48540.decode((Object)buffer));
                }
                resolvedDrops.add(new RecipeViewerDrop(minStage, maxStage, chance, result, tooltip));
            }
            OreGrowthRecipe recipe = new OreGrowthRecipe(bases, stages, spawnChance, growthChance, drops);
            recipe.resolvedDrops = resolvedDrops;
            return recipe;
        }

        public static void toNetwork(class_9129 buffer, OreGrowthRecipe recipe) {
            buffer.method_53002(recipe.bases.size());
            for (Either<class_2248, class_6862<class_2248>> either : recipe.bases) {
                buffer.method_52964(either.isLeft());
                buffer.method_10812((class_2960)either.flatMap(arg_0 -> ((Registries.Registry)Registries.BLOCKS).getIdentifier(arg_0), class_6862::comp_327));
            }
            buffer.method_53002(recipe.stages);
            buffer.method_52940(recipe.spawnChance);
            buffer.method_52940(recipe.growthChance);
            buffer.method_53002(recipe.drops.size());
            for (OreGrowthDrop oreGrowthDrop : recipe.drops) {
                buffer.method_53002(oreGrowthDrop.minStage);
                buffer.method_53002(oreGrowthDrop.maxStage);
                buffer.method_52940(oreGrowthDrop.chance);
                buffer.method_52964(oreGrowthDrop.result.isLeft());
                oreGrowthDrop.result.ifLeft(item -> class_1799.field_49268.encode((Object)buffer, item));
                oreGrowthDrop.result.ifRight(arg_0 -> ((class_9129)buffer).method_10812(arg_0));
            }
            if (CommonUtils.getServer() != null && CommonUtils.getServer().method_58576() != null) {
                recipe.resolveDrops(identifier -> CommonUtils.getServer().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)identifier)));
            }
            if (recipe.resolvedDrops == null) {
                buffer.method_53002(0);
                return;
            }
            buffer.method_53002(recipe.resolvedDrops.size());
            for (RecipeViewerDrop recipeViewerDrop : recipe.resolvedDrops) {
                buffer.method_53002(recipeViewerDrop.minStage);
                buffer.method_53002(recipeViewerDrop.maxStage);
                buffer.method_52940(recipeViewerDrop.chance);
                class_1799.field_49268.encode((Object)buffer, (Object)recipeViewerDrop.result);
                buffer.method_53002(recipeViewerDrop.tooltip.size());
                for (class_2561 class_25612 : recipeViewerDrop.tooltip) {
                    class_8824.field_48540.encode((Object)buffer, (Object)class_25612);
                }
            }
        }
    }
}

