/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public abstract class OreGrowthRecipeGenerator
extends ResourceGenerator {
    private final Map<class_2960, OreGrowthRecipeBuilder> recipes = new HashMap<class_2960, OreGrowthRecipeBuilder>();

    public OreGrowthRecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public OreGrowthRecipeBuilder recipe(String namespace, String location, class_2960 base, int stages, double spawnChance, double growthChance) {
        if (stages < 1 || stages > 4) {
            throw new RuntimeException("Invalid number of stages: '" + stages + "'!");
        }
        if (spawnChance <= 0.0 || spawnChance > 1.0) {
            throw new RuntimeException("Invalid spawn chance: '" + spawnChance + "'!");
        }
        if (growthChance <= 0.0 || growthChance > 1.0) {
            throw new RuntimeException("Invalid growth chance: '" + growthChance + "'!");
        }
        class_2960 identifier = class_2960.method_60655((String)namespace, (String)location);
        if (this.recipes.containsKey(identifier)) {
            throw new RuntimeException("Duplicate recipe for location '" + String.valueOf(identifier) + "'!");
        }
        OreGrowthRecipeBuilder recipe = new OreGrowthRecipeBuilder(base, stages, spawnChance, growthChance);
        this.recipes.put(identifier, recipe);
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, namespace, "recipe", location, ".json");
        return recipe;
    }

    public OreGrowthRecipeBuilder recipe(String location, class_2248 base, int stages, double spawnChance, double growthChance) {
        return this.recipe(this.modid, location, Registries.BLOCKS.getIdentifier((Object)base), stages, spawnChance, growthChance);
    }

    public OreGrowthRecipeBuilder modIntegration(String modid, String base, int stages, double spawnChance, double growthChance) {
        class_2960 baseIdentifier = base.contains(":") ? class_2960.method_60654((String)base) : class_2960.method_60655((String)modid, (String)base);
        return this.recipe(this.modid, modid + "_" + baseIdentifier.method_12832() + "_growth", baseIdentifier, stages, spawnChance, growthChance).defaultNamespace(modid).modLoadedCondition(modid);
    }

    public void save() {
        for (Map.Entry<class_2960, OreGrowthRecipeBuilder> entry : this.recipes.entrySet()) {
            OreGrowthRecipeBuilder recipe = entry.getValue();
            JsonObject json = new JsonObject();
            json.addProperty("type", "oregrowth:ore_growth");
            if (recipe.bases.size() == 1) {
                json.addProperty("base", (String)recipe.bases.stream().findAny().get());
            } else {
                JsonArray bases = new JsonArray(recipe.bases.size());
                recipe.bases.forEach(arg_0 -> ((JsonArray)bases).add(arg_0));
                json.add("base", (JsonElement)bases);
            }
            json.addProperty("stages", (Number)recipe.stages);
            json.addProperty("spawn_chance", (Number)recipe.spawnChance);
            json.addProperty("growth_chance", (Number)recipe.growthChance);
            JsonArray drops = new JsonArray();
            for (OreGrowthDrop drop : recipe.drops) {
                JsonObject dropJson = new JsonObject();
                if (drop.minStage == drop.maxStage) {
                    dropJson.addProperty("stage", (Number)drop.minStage);
                } else {
                    dropJson.addProperty("min_stage", (Number)drop.minStage);
                    dropJson.addProperty("max_stage", (Number)drop.maxStage);
                }
                if (drop.chance != 1.0) {
                    dropJson.addProperty("chance", (Number)drop.chance);
                }
                if (drop.item != null) {
                    JsonObject itemJson = new JsonObject();
                    itemJson.addProperty("id", drop.item.toString());
                    itemJson.addProperty("count", (Number)drop.count);
                    dropJson.add("item", (JsonElement)itemJson);
                } else {
                    dropJson.addProperty("loot_table", drop.lootTable.toString());
                }
                drops.add((JsonElement)dropJson);
            }
            json.add("drops", (JsonElement)drops);
            List<ResourceCondition> conditions = recipe.conditions;
            if (!conditions.isEmpty()) {
                json = ConditionalRecipeSerializer.wrapRecipe((JsonObject)json, conditions);
            }
            class_2960 location = entry.getKey();
            this.cache.saveJsonResource(ResourceType.DATA, json, location.method_12836(), "recipe", location.method_12832() + ".json");
        }
    }

    public static class OreGrowthRecipeBuilder {
        private String baseNamespace;
        private final Set<String> bases = new LinkedHashSet<String>();
        private final int stages;
        private final double spawnChance;
        private final double growthChance;
        private final List<OreGrowthDrop> drops = new ArrayList<OreGrowthDrop>();
        private final List<ResourceCondition> conditions = new ArrayList<ResourceCondition>();

        public OreGrowthRecipeBuilder(class_2960 base, int stages, double spawnChance, double growthChance) {
            this.bases.add(base.toString());
            this.stages = stages;
            this.spawnChance = spawnChance;
            this.growthChance = growthChance;
        }

        public OreGrowthRecipeBuilder defaultNamespace(String namespace) {
            this.baseNamespace = namespace;
            return this;
        }

        public OreGrowthRecipeBuilder baseBlock(class_2960 block) {
            if (!this.bases.add(block.toString())) {
                throw new IllegalStateException("Duplicate base block '" + String.valueOf(block) + "'!");
            }
            return this;
        }

        public OreGrowthRecipeBuilder baseBlock(class_2248 block) {
            return this.baseBlock(Registries.BLOCKS.getIdentifier((Object)block));
        }

        public OreGrowthRecipeBuilder baseBlock(String namespace, String identifier) {
            return this.baseBlock(class_2960.method_60655((String)namespace, (String)identifier));
        }

        public OreGrowthRecipeBuilder baseBlock(String block) {
            return this.baseBlock(this.parseIdentifier(block));
        }

        public OreGrowthRecipeBuilder baseTag(class_2960 tag) {
            if (!this.bases.add("#" + String.valueOf(tag))) {
                throw new IllegalStateException("Duplicate base tag '" + String.valueOf(tag) + "'!");
            }
            return this;
        }

        public OreGrowthRecipeBuilder baseTag(class_6862<class_2248> tag) {
            return this.baseTag(tag.comp_327());
        }

        public OreGrowthRecipeBuilder baseTag(String namespace, String identifier) {
            return this.baseTag(class_2960.method_60655((String)namespace, (String)identifier));
        }

        public OreGrowthRecipeBuilder baseTag(String tag) {
            return this.baseTag(this.parseIdentifier(tag));
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, class_2960 item, int count) {
            if (minStage <= 0 || minStage > 4) {
                throw new IllegalArgumentException("Minimum stage must be between 1 and 4, not '" + minStage + "'!");
            }
            if (maxStage <= 0 || maxStage > 4) {
                throw new IllegalArgumentException("Maximum stage must be between 1 and 4, not '" + maxStage + "'!");
            }
            if (minStage > maxStage) {
                throw new IllegalArgumentException("Minimum stage must be less than maximum stage!");
            }
            if (chance <= 0.0 || chance > 1.0) {
                throw new IllegalArgumentException("Chance must be between 0 and 1, not '" + chance + "'!");
            }
            if (count <= 0) {
                throw new RuntimeException("Count must be at least 1, not '" + count + "'!");
            }
            this.drops.add(new OreGrowthDrop(minStage, maxStage, chance, item, count, null));
            return this;
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, class_1935 item, int count) {
            return this.itemDrop(minStage, maxStage, chance, Registries.ITEMS.getIdentifier((Object)item.method_8389()), count);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, String namespace, String identifier, int count) {
            return this.itemDrop(minStage, maxStage, chance, class_2960.method_60655((String)namespace, (String)identifier), count);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, String item, int count) {
            return this.itemDrop(minStage, maxStage, chance, this.parseIdentifier(item), count);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, class_2960 item) {
            return this.itemDrop(minStage, maxStage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, class_1935 item) {
            return this.itemDrop(minStage, maxStage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, String namespace, String identifier) {
            return this.itemDrop(minStage, maxStage, chance, namespace, identifier, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int minStage, int maxStage, double chance, String item) {
            return this.itemDrop(minStage, maxStage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, class_2960 item, int count) {
            return this.itemDrop(stage, stage, chance, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, class_1935 item, int count) {
            return this.itemDrop(stage, stage, chance, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, String namespace, String identifier, int count) {
            return this.itemDrop(stage, stage, chance, namespace, identifier, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, String item, int count) {
            return this.itemDrop(stage, stage, chance, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, class_2960 item) {
            return this.itemDrop(stage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, class_1935 item) {
            return this.itemDrop(stage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, String namespace, String identifier) {
            return this.itemDrop(stage, chance, namespace, identifier, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, double chance, String item) {
            return this.itemDrop(stage, chance, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, class_2960 item, int count) {
            return this.itemDrop(stage, 1.0, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, class_1935 item, int count) {
            return this.itemDrop(stage, 1.0, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, String namespace, String identifier, int count) {
            return this.itemDrop(stage, 1.0, namespace, identifier, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, String item, int count) {
            return this.itemDrop(stage, 1.0, item, count);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, class_2960 item) {
            return this.itemDrop(stage, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, class_1935 item) {
            return this.itemDrop(stage, item, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, String namespace, String identifier) {
            return this.itemDrop(stage, namespace, identifier, 1);
        }

        public OreGrowthRecipeBuilder itemDrop(int stage, String item) {
            return this.itemDrop(stage, item, 1);
        }

        public OreGrowthRecipeBuilder lootTableDrop(int minStage, int maxStage, double chance, class_2960 lootTable) {
            if (minStage <= 0 || minStage > 4) {
                throw new IllegalArgumentException("Minimum stage must be between 1 and 4, not '" + minStage + "'!");
            }
            if (maxStage <= 0 || maxStage > 4) {
                throw new IllegalArgumentException("Maximum stage must be between 1 and 4, not '" + maxStage + "'!");
            }
            if (minStage > maxStage) {
                throw new IllegalArgumentException("Minimum stage must be less than maximum stage!");
            }
            if (chance <= 0.0 || chance > 1.0) {
                throw new IllegalArgumentException("Chance must be between 0 and 1, not '" + chance + "'!");
            }
            this.drops.add(new OreGrowthDrop(minStage, maxStage, chance, null, 0, lootTable));
            return this;
        }

        public OreGrowthRecipeBuilder lootTableDrop(int stage, double chance, class_2960 lootTable) {
            return this.lootTableDrop(stage, stage, chance, lootTable);
        }

        public OreGrowthRecipeBuilder lootTableDrop(int stage, class_2960 lootTable) {
            return this.lootTableDrop(stage, 1.0, lootTable);
        }

        public OreGrowthRecipeBuilder condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public OreGrowthRecipeBuilder modLoadedCondition(String modid) {
            return this.condition((ResourceCondition)new ModLoadedResourceCondition(modid));
        }

        private class_2960 parseIdentifier(String identifier) {
            if (this.baseNamespace == null) {
                return class_2960.method_60654((String)identifier);
            }
            int separatorIndex = identifier.indexOf(58);
            if (separatorIndex < 0) {
                return class_2960.method_60655((String)this.baseNamespace, (String)identifier);
            }
            return class_2960.method_60655((String)identifier.substring(0, separatorIndex), (String)identifier.substring(separatorIndex + 1));
        }
    }

    private record OreGrowthDrop(int minStage, int maxStage, double chance, class_2960 item, int count, class_2960 lootTable) {
    }
}

